/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceExceptionTranslationAdvisor
extends DefaultPointcutAdvisor {
    public PersistenceExceptionTranslationAdvisor(PersistenceExceptionTranslator persistenceExceptionTranslator, Class<? extends Annotation> repositoryAnnotationType) {
        super(new RepositoryAnnotationMatchingPointcut(repositoryAnnotationType), new PersistenceExceptionTranslationInterceptor(persistenceExceptionTranslator));
    }

    private static class PersistenceExceptionTranslationInterceptor
    implements MethodInterceptor {
        private final PersistenceExceptionTranslator persistenceExceptionTranslator;

        public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
            this.persistenceExceptionTranslator = persistenceExceptionTranslator;
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            try {
                return mi.proceed();
            }
            catch (RuntimeException ex) {
                for (Class<?> exceptionClass : mi.getMethod().getExceptionTypes()) {
                    if (!exceptionClass.isInstance(ex)) continue;
                    throw ex;
                }
                throw DataAccessUtils.translateIfNecessary(ex, this.persistenceExceptionTranslator);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryAnnotationMatchingPointcut
    extends StaticMethodMatcherPointcut {
        public RepositoryAnnotationMatchingPointcut(final Class<? extends Annotation> repositoryAnnotationType) {
            this.setClassFilter(new ClassFilter(){

                public boolean matches(Class clazz) {
                    return clazz.isAnnotationPresent(repositoryAnnotationType);
                }
            });
        }

        @Override
        public boolean matches(Method method, Class targetClass) {
            return true;
        }
    }
}

