/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.classic.Session;
import org.hibernate.impl.SessionImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements BeanFactoryAware,
InitializingBean {
    private static boolean hibernateSetTimeoutAvailable;
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private boolean prepareConnection = true;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$hibernate$Transaction;
    static /* synthetic */ Class class$org$hibernate$Interceptor;

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptor = entityInterceptorBeanName;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof Interceptor) {
            return (Interceptor)this.entityInterceptor;
        }
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            String beanName = (String)this.entityInterceptor;
            return (Interceptor)this.beanFactory.getBean(beanName, class$org$hibernate$Interceptor == null ? (class$org$hibernate$Interceptor = HibernateTransactionManager.class$("org.hibernate.Interceptor")) : class$org$hibernate$Interceptor);
        }
        return null;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.jdbcExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        DataSource sfds;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
        if (this.entityInterceptor instanceof String && this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is required for entityInterceptorBeanName");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (sfds = SessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + sfds + "] of Hibernate SessionFactory for HibernateTransactionManager"));
            }
            this.setDataSource(sfds);
        }
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound Session [" + SessionFactoryUtils.toString(sessionHolder.getSession()) + "] for Hibernate transaction"));
            }
            txObject.setSessionHolder(sessionHolder, false);
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
                txObject.setConnectionHolder(conHolder);
            }
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((HibernateTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource(this.getDataSource())) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found - HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        org.hibernate.Session session = null;
        try {
            FlushMode flushMode;
            HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
            if (txObject.getSessionHolder() == null) {
                Session newSession;
                Interceptor entityInterceptor = this.getEntityInterceptor();
                Session session2 = newSession = entityInterceptor != null ? this.getSessionFactory().openSession(entityInterceptor) : this.getSessionFactory().openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new Session [" + SessionFactoryUtils.toString((org.hibernate.Session)newSession) + "] for Hibernate transaction"));
                }
                txObject.setSessionHolder(new SessionHolder((org.hibernate.Session)newSession), true);
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
            session = txObject.getSessionHolder().getSession();
            if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]"));
                }
                Connection con = session.connection();
                Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction(con, definition);
                txObject.setPreviousIsolationLevel(previousIsolationLevel);
            } else {
                if (definition.getIsolationLevel() != -1) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (LocalSessionFactoryBean's default)");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]"));
                }
            }
            if (definition.isReadOnly() && txObject.isNewSessionHolder()) {
                session.setFlushMode(FlushMode.NEVER);
            }
            if (!definition.isReadOnly() && !txObject.isNewSessionHolder() && FlushMode.NEVER.equals(flushMode = session.getFlushMode())) {
                session.setFlushMode(FlushMode.AUTO);
                txObject.getSessionHolder().setPreviousFlushMode(flushMode);
            }
            Transaction hibTx = null;
            if (definition.getTimeout() != -1) {
                if (hibernateSetTimeoutAvailable) {
                    hibTx = session.getTransaction();
                    hibTx.setTimeout(definition.getTimeout());
                    hibTx.begin();
                } else {
                    hibTx = session.beginTransaction();
                    txObject.getSessionHolder().setTimeoutInSeconds(definition.getTimeout());
                }
            } else {
                hibTx = session.beginTransaction();
            }
            txObject.getSessionHolder().setTransaction(hibTx);
            if (this.getDataSource() != null) {
                Connection con = session.connection();
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing Hibernate transaction as JDBC transaction [" + con + "]"));
                }
                TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource(this.getSessionFactory(), txObject.getSessionHolder());
            }
        }
        catch (Exception ex) {
            SessionFactoryUtils.closeSession(session);
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        txObject.setSessionHolder(null, false);
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource(this.getSessionFactory(), resourcesHolder.getSessionHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", ex);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().rollback();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not roll back Hibernate transaction", ex);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            if (!txObject.isNewSessionHolder()) {
                txObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Hibernate transaction on Session [" + SessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        org.hibernate.Session session = txObject.getSessionHolder().getSession();
        if (this.prepareConnection && session.isConnected() && this.isSameConnectionForEntireSession(session)) {
            try {
                Connection con = session.connection();
                DataSourceUtils.resetConnectionAfterTransaction(con, txObject.getPreviousIsolationLevel());
            }
            catch (HibernateException ex) {
                this.logger.debug((Object)"Could not access JDBC Connection of Hibernate Session", (Throwable)ex);
            }
        }
        if (txObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction"));
            }
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing pre-bound Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction"));
            }
            if (txObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getSessionHolder().getPreviousFlushMode());
            }
            if (hibernateSetTimeoutAvailable) {
                session.disconnect();
            }
        }
        txObject.getSessionHolder().clear();
    }

    protected boolean isSameConnectionForEntireSession(org.hibernate.Session session) {
        if (!(session instanceof SessionImpl)) {
            return true;
        }
        ConnectionReleaseMode releaseMode = ((SessionImpl)session).getConnectionReleaseMode();
        return ConnectionReleaseMode.ON_CLOSE.equals(releaseMode);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex);
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation: " + ex.getMessage(), ex.getSQL(), ex.getSQLException());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            (class$org$hibernate$Transaction == null ? (class$org$hibernate$Transaction = HibernateTransactionManager.class$("org.hibernate.Transaction")) : class$org$hibernate$Transaction).getMethod("setTimeout", Integer.TYPE);
            hibernateSetTimeoutAvailable = true;
        }
        catch (NoSuchMethodException ex) {
            hibernateSetTimeoutAvailable = false;
        }
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private static class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;

        private HibernateTransactionObject() {
        }

        public void setSessionHolder(SessionHolder sessionHolder, boolean newSessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = newSessionHolder;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public void setRollbackOnly() {
            this.getSessionHolder().setRollbackOnly();
            if (this.getConnectionHolder() != null) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly() || this.getConnectionHolder() != null && this.getConnectionHolder().isRollbackOnly();
        }
    }
}

