/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import javax.portlet.PortletRequest;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.HandlerMapping;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultHandler;
    private HandlerInterceptor[] interceptors;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setDefaultHandler(Object defaultHandler) {
        this.defaultHandler = defaultHandler;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Default mapping to handler [" + this.defaultHandler + "]"));
        }
    }

    protected final Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public final void setInterceptors(HandlerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public final HandlerExecutionChain getHandler(PortletRequest request) throws Exception {
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.getApplicationContext().getBean(handlerName);
        }
        return new HandlerExecutionChain(handler, this.interceptors);
    }

    protected abstract Object getHandlerInternal(PortletRequest var1) throws Exception;
}

