/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.portlet.handler.AbstractHandlerMapping;

public class PortletModeHandlerMapping
extends AbstractHandlerMapping {
    private Map portletModeMap;
    private boolean lazyInitHandlers = false;
    private final Map handlerMap = new HashMap();

    public void setPortletModeMap(Map portletModeMap) {
        this.portletModeMap = portletModeMap;
    }

    public void setMappings(Properties mappings) {
        this.portletModeMap = mappings;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public void initApplicationContext() throws BeansException {
        if (this.portletModeMap == null || this.portletModeMap.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Neither 'portletModeMap' nor 'mappings' set on PortletModeHandlerMapping");
            }
        } else {
            Iterator it = this.portletModeMap.keySet().iterator();
            while (it.hasNext()) {
                String modeKey = (String)it.next();
                PortletMode mode = new PortletMode(modeKey);
                Object handler = this.portletModeMap.get(modeKey);
                this.registerHandler(mode, handler);
            }
        }
    }

    protected void registerHandler(PortletMode mode, Object handler) throws BeansException {
        Object mappedHandler = this.handlerMap.get(mode);
        if (mappedHandler != null) {
            throw new ApplicationContextException("Cannot map handler [" + handler + "] to mode [" + mode + "]: there's already handler [" + mappedHandler + "] mapped");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        this.handlerMap.put(mode, handler);
        this.logger.info((Object)("Mapped mode [" + mode + "] onto handler [" + handler + "]"));
    }

    protected Object getHandlerInternal(PortletRequest request) throws Exception {
        PortletMode mode = request.getPortletMode();
        Object handler = this.handlerMap.get(mode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Portlet mode '" + mode + "' -> handler [" + handler + "]"));
        }
        return handler;
    }
}

