/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jdo.DefaultJdoDialect;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.util.CollectionUtils;

public class LocalPersistenceManagerFactoryBean
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String persistenceManagerFactoryName;
    private Resource configLocation;
    private final Map jdoPropertyMap = new HashMap();
    private ClassLoader beanClassLoader;
    private PersistenceManagerFactory persistenceManagerFactory;
    private JdoDialect jdoDialect;

    public void setPersistenceManagerFactoryName(String persistenceManagerFactoryName) {
        this.persistenceManagerFactoryName = persistenceManagerFactoryName;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setJdoProperties(Properties jdoProperties) {
        CollectionUtils.mergePropertiesIntoMap(jdoProperties, this.jdoPropertyMap);
    }

    public void setJdoPropertyMap(Map jdoProperties) {
        if (jdoProperties != null) {
            this.jdoPropertyMap.putAll(jdoProperties);
        }
    }

    public Map getJdoPropertyMap() {
        return this.jdoPropertyMap;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, IOException, JDOException {
        if (this.persistenceManagerFactoryName != null) {
            if (this.configLocation != null || !this.jdoPropertyMap.isEmpty()) {
                throw new IllegalStateException("'configLocation'/'jdoProperties' not supported in combination with 'persistenceManagerFactoryName' - specify one or the other, not both");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Building new JDO PersistenceManagerFactory for name '" + this.persistenceManagerFactoryName + "'"));
            }
            this.persistenceManagerFactory = this.newPersistenceManagerFactory(this.persistenceManagerFactoryName);
        } else {
            HashMap<Object, Object> mergedProps = new HashMap<Object, Object>();
            if (this.configLocation != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading JDO config from [" + this.configLocation + "]"));
                }
                mergedProps.putAll(PropertiesLoaderUtils.loadProperties(this.configLocation));
            }
            mergedProps.putAll(this.jdoPropertyMap);
            this.logger.info((Object)"Building new JDO PersistenceManagerFactory");
            this.persistenceManagerFactory = this.newPersistenceManagerFactory(mergedProps);
        }
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.persistenceManagerFactory.getConnectionFactory());
        }
    }

    protected PersistenceManagerFactory newPersistenceManagerFactory(String name) {
        return JDOHelper.getPersistenceManagerFactory((String)name, (ClassLoader)this.beanClassLoader);
    }

    protected PersistenceManagerFactory newPersistenceManagerFactory(Map props) {
        return JDOHelper.getPersistenceManagerFactory((Map)props, (ClassLoader)this.beanClassLoader);
    }

    public Object getObject() {
        return this.persistenceManagerFactory;
    }

    public Class getObjectType() {
        return this.persistenceManagerFactory != null ? this.persistenceManagerFactory.getClass() : PersistenceManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof JDOException) {
            if (this.jdoDialect != null) {
                return this.jdoDialect.translateException((JDOException)ex);
            }
            return PersistenceManagerFactoryUtils.convertJdoAccessException((JDOException)ex);
        }
        return null;
    }

    public void destroy() {
        this.logger.info((Object)"Closing JDO PersistenceManagerFactory");
        this.persistenceManagerFactory.close();
    }
}

