/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j2;

import java.util.List;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.springframework.ws.context.MessageContext;
import org.w3c.dom.Document;

class Wss4jHandler
extends WSHandler {
    private Properties options = new Properties();
    private String securementPassword;
    private Crypto securementEncryptionCrypto;
    private Crypto securementSignatureCrypto;

    Wss4jHandler() {
        this.options.setProperty("mustUnderstand", Boolean.toString(true));
        this.options.setProperty("enableSignatureConfirmation", Boolean.toString(true));
    }

    public void doSenderAction(Document doc, RequestData reqData, List<HandlerAction> actions, boolean isRequest) throws WSSecurityException {
        super.doSenderAction(doc, reqData, actions, isRequest);
    }

    protected boolean checkReceiverResultsAnyOrder(List<WSSecurityEngineResult> wsResult, List<Integer> actions) {
        return super.checkReceiverResultsAnyOrder(wsResult, actions);
    }

    void setOption(String key, String value) {
        this.options.setProperty(key, value);
    }

    void setOption(String key, boolean value) {
        this.options.setProperty(key, Boolean.toString(value));
    }

    public Object getOption(String key) {
        return this.options.getProperty(key);
    }

    void setSecurementPassword(String securementPassword) {
        this.securementPassword = securementPassword;
    }

    void setSecurementEncryptionCrypto(Crypto securementEncryptionCrypto) {
        this.securementEncryptionCrypto = securementEncryptionCrypto;
    }

    void setSecurementSignatureCrypto(Crypto securementSignatureCrypto) {
        this.securementSignatureCrypto = securementSignatureCrypto;
    }

    public String getPassword(Object msgContext) {
        return this.securementPassword;
    }

    public Object getProperty(Object msgContext, String key) {
        return ((MessageContext)msgContext).getProperty(key);
    }

    protected Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        return this.securementEncryptionCrypto;
    }

    public Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        return this.securementSignatureCrypto;
    }

    public void setPassword(Object msgContext, String password) {
        this.securementPassword = password;
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((MessageContext)msgContext).setProperty(key, value);
    }
}

