/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;
import org.springframework.ws.soap.axiom.AxiomSoapMessageCreationException;
import org.springframework.ws.soap.support.SoapUtils;
import org.springframework.ws.transport.TransportInputStream;

public class AxiomSoapMessageFactory
implements SoapMessageFactory,
InitializingBean {
    private static final String CHARSET_PARAMETER = "charset";
    private static final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private static final String MULTI_PART_RELATED_CONTENT_TYPE = "multipart/related";
    private static final Log logger = LogFactory.getLog(AxiomSoapMessageFactory.class);
    private final XMLInputFactory inputFactory = this.createXmlInputFactory();
    private boolean payloadCaching = true;
    private boolean attachmentCaching = false;
    private File attachmentCacheDir;
    private int attachmentCacheThreshold = 4096;
    private SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
    private boolean langAttributeOnSoap11FaultString = true;

    public void setPayloadCaching(boolean payloadCaching) {
        this.payloadCaching = payloadCaching;
    }

    public void setAttachmentCaching(boolean attachmentCaching) {
        this.attachmentCaching = attachmentCaching;
    }

    public void setAttachmentCacheDir(File attachmentCacheDir) {
        Assert.notNull((Object)attachmentCacheDir, (String)"'attachmentCacheDir' must not be null");
        Assert.isTrue((boolean)attachmentCacheDir.isDirectory(), (String)"'attachmentCacheDir' must be a directory");
        Assert.isTrue((boolean)attachmentCacheDir.canWrite(), (String)"'attachmentCacheDir' must be writable");
        this.attachmentCacheDir = attachmentCacheDir;
    }

    public void setAttachmentCacheThreshold(int attachmentCacheThreshold) {
        Assert.isTrue((attachmentCacheThreshold > 0 ? 1 : 0) != 0, (String)"'attachmentCacheThreshold' must be larger than 0");
        this.attachmentCacheThreshold = attachmentCacheThreshold;
    }

    public void setSoapVersion(SoapVersion version) {
        if (SoapVersion.SOAP_11 == version) {
            this.soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (SoapVersion.SOAP_12 == version) {
            this.soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            throw new IllegalArgumentException("Invalid version [" + version + "]. " + "Expected the SOAP_11 or SOAP_12 constant");
        }
    }

    public void setLangAttributeOnSoap11FaultString(boolean langAttributeOnSoap11FaultString) {
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.payloadCaching ? "Enabled payload caching" : "Disabled payload caching"));
        }
        if (this.attachmentCacheDir == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            this.setAttachmentCacheDir(new File(tempDir));
        }
    }

    public AxiomSoapMessage createWebServiceMessage() {
        return new AxiomSoapMessage(this.soapFactory, this.payloadCaching, this.langAttributeOnSoap11FaultString);
    }

    public AxiomSoapMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        String soapAction;
        Assert.isInstanceOf(TransportInputStream.class, (Object)inputStream, (String)"AxiomSoapMessageFactory requires a TransportInputStream");
        TransportInputStream transportInputStream = (TransportInputStream)inputStream;
        String contentType = this.getHeaderValue(transportInputStream, "Content-Type");
        if (!StringUtils.hasLength((String)contentType)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TransportInputStream has no Content-Type header; defaulting to \"" + SoapVersion.SOAP_11.getContentType() + "\""));
            }
            contentType = SoapVersion.SOAP_11.getContentType();
        }
        if (!StringUtils.hasLength((String)(soapAction = this.getHeaderValue(transportInputStream, "SOAPAction")))) {
            soapAction = SoapUtils.extractActionFromContentType(contentType);
        }
        try {
            if (this.isMultiPartRelated(contentType)) {
                return this.createMultiPartAxiomSoapMessage(inputStream, contentType, soapAction);
            }
            return this.createAxiomSoapMessage(inputStream, contentType, soapAction);
        }
        catch (XMLStreamException ex) {
            throw new AxiomSoapMessageCreationException("Could not parse request: " + ex.getMessage(), ex);
        }
        catch (OMException ex) {
            throw new AxiomSoapMessageCreationException("Could not create message: " + ex.getMessage(), ex);
        }
    }

    private String getHeaderValue(TransportInputStream transportInputStream, String header) throws IOException {
        String contentType = null;
        Iterator<String> iterator = transportInputStream.getHeaders(header);
        if (iterator.hasNext()) {
            contentType = iterator.next();
        }
        return contentType;
    }

    private boolean isMultiPartRelated(String contentType) {
        contentType = contentType.toLowerCase(Locale.ENGLISH);
        return contentType.contains(MULTI_PART_RELATED_CONTENT_TYPE);
    }

    private AxiomSoapMessage createAxiomSoapMessage(InputStream inputStream, String contentType, String soapAction) throws XMLStreamException {
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(inputStream, this.getCharSetEncoding(contentType));
        String envelopeNamespace = this.getSoapEnvelopeNamespace(contentType);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, this.soapFactory, envelopeNamespace);
        SOAPMessage soapMessage = builder.getSoapMessage();
        return new AxiomSoapMessage(soapMessage, soapAction, this.payloadCaching, this.langAttributeOnSoap11FaultString);
    }

    private AxiomSoapMessage createMultiPartAxiomSoapMessage(InputStream inputStream, String contentType, String soapAction) throws XMLStreamException {
        StAXSOAPModelBuilder builder;
        Attachments attachments = new Attachments(inputStream, contentType, this.attachmentCaching, this.attachmentCacheDir.getAbsolutePath(), Integer.toString(this.attachmentCacheThreshold));
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(attachments.getRootPartInputStream(), this.getCharSetEncoding(attachments.getRootPartContentType()));
        String envelopeNamespace = this.getSoapEnvelopeNamespace(contentType);
        if ("text/xml".equals(attachments.getAttachmentSpecType()) || "application/soap+xml".equals(attachments.getAttachmentSpecType())) {
            builder = new StAXSOAPModelBuilder(reader, this.soapFactory, envelopeNamespace);
        } else if ("application/xop+xml".equals(attachments.getAttachmentSpecType())) {
            builder = new MTOMStAXSOAPModelBuilder(reader, attachments, envelopeNamespace);
        } else {
            throw new AxiomSoapMessageCreationException("Unknown attachment type: [" + attachments.getAttachmentSpecType() + "]");
        }
        return new AxiomSoapMessage(builder.getSoapMessage(), attachments, soapAction, this.payloadCaching, this.langAttributeOnSoap11FaultString);
    }

    private String getSoapEnvelopeNamespace(String contentType) {
        if (contentType.contains("text/xml")) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (contentType.contains("application/soap+xml")) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        throw new AxiomSoapMessageCreationException("Unknown content type '" + contentType + "'");
    }

    protected String getCharSetEncoding(String contentType) {
        int charSetIdx = contentType.indexOf(CHARSET_PARAMETER);
        if (charSetIdx == -1) {
            return DEFAULT_CHARSET_ENCODING;
        }
        int eqIdx = contentType.indexOf("=", charSetIdx);
        int indexOfSemiColon = contentType.indexOf(";", eqIdx);
        String value = indexOfSemiColon > 0 ? contentType.substring(eqIdx + 1, indexOfSemiColon) : contentType.substring(eqIdx + 1, contentType.length()).trim();
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            return value.substring(0, value.length() - 1);
        }
        if ("null".equalsIgnoreCase(value)) {
            return DEFAULT_CHARSET_ENCODING;
        }
        return value.trim();
    }

    protected XMLInputFactory createXmlInputFactory() {
        return XMLInputFactory.newInstance();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AxiomSoapMessageFactory[");
        if (this.soapFactory.getSOAPVersion() == SOAP11Version.getSingleton()) {
            builder.append("SOAP 1.1");
        } else if (this.soapFactory.getSOAPVersion() == SOAP12Version.getSingleton()) {
            builder.append("SOAP 1.2");
        }
        builder.append(',');
        if (this.payloadCaching) {
            builder.append("PayloadCaching enabled");
        } else {
            builder.append("PayloadCaching disabled");
        }
        builder.append(']');
        return builder.toString();
    }
}

