/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.springframework.util.Assert;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.soap.saaj.SaajAttachmentException;

class SaajAttachment
implements Attachment {
    private final AttachmentPart saajAttachment;

    public SaajAttachment(AttachmentPart saajAttachment) {
        Assert.notNull((Object)saajAttachment, (String)"saajAttachment must not be null");
        this.saajAttachment = saajAttachment;
    }

    public String getContentId() {
        return this.saajAttachment.getContentId();
    }

    public String getContentType() {
        return this.saajAttachment.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.saajAttachment.getDataHandler().getInputStream();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }

    public long getSize() {
        try {
            return this.saajAttachment.getSize();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }

    public DataHandler getDataHandler() {
        try {
            return this.saajAttachment.getDataHandler();
        }
        catch (SOAPException ex) {
            throw new SaajAttachmentException(ex);
        }
    }
}

