/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.springframework.ws.transport.AbstractWebServiceConnection;
import org.springframework.ws.transport.TransportInputStream;
import org.springframework.ws.transport.TransportOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSenderConnection
extends AbstractWebServiceConnection {
    private TransportOutputStream requestOutputStream;
    private TransportInputStream responseInputStream;

    @Override
    protected final TransportOutputStream createTransportOutputStream() throws IOException {
        if (this.requestOutputStream == null) {
            this.requestOutputStream = new RequestTransportOutputStream();
        }
        return this.requestOutputStream;
    }

    @Override
    protected final TransportInputStream createTransportInputStream() throws IOException {
        if (this.hasResponse()) {
            if (this.responseInputStream == null) {
                this.responseInputStream = new ResponseTransportInputStream();
            }
            return this.responseInputStream;
        }
        return null;
    }

    @Override
    protected void onClose() throws IOException {
    }

    protected abstract boolean hasResponse() throws IOException;

    protected abstract void addRequestHeader(String var1, String var2) throws IOException;

    protected abstract OutputStream getRequestOutputStream() throws IOException;

    protected abstract Iterator<String> getResponseHeaderNames() throws IOException;

    protected abstract Iterator<String> getResponseHeaders(String var1) throws IOException;

    protected abstract InputStream getResponseInputStream() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResponseTransportInputStream
    extends TransportInputStream {
        ResponseTransportInputStream() {
        }

        @Override
        protected InputStream createInputStream() throws IOException {
            return AbstractSenderConnection.this.getResponseInputStream();
        }

        @Override
        public Iterator<String> getHeaderNames() throws IOException {
            return AbstractSenderConnection.this.getResponseHeaderNames();
        }

        @Override
        public Iterator<String> getHeaders(String name) throws IOException {
            return AbstractSenderConnection.this.getResponseHeaders(name);
        }
    }

    class RequestTransportOutputStream
    extends TransportOutputStream {
        RequestTransportOutputStream() {
        }

        public void addHeader(String name, String value) throws IOException {
            AbstractSenderConnection.this.addRequestHeader(name, value);
        }

        protected OutputStream createOutputStream() throws IOException {
            return AbstractSenderConnection.this.getRequestOutputStream();
        }
    }
}

