/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.JavascriptClassGenerationException;
import org.stjs.generator.NamespaceUtil;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.utils.ClassUtils;
import org.stjs.generator.utils.PreConditions;
import org.stjs.javascript.annotation.STJSBridge;

@Immutable
public class BridgeClass
implements ClassWithJavascript {
    private final Class<?> clazz;
    private final String jsNamespace;

    public BridgeClass(ClassResolver classResolver, Class<?> clazz) {
        PreConditions.checkNotNull(classResolver);
        PreConditions.checkNotNull(clazz);
        this.clazz = clazz;
        String ns = NamespaceUtil.resolveNamespace(clazz);
        if (ns == null) {
            ns = "";
        }
        this.jsNamespace = ns;
    }

    @Override
    public String getJavaClassName() {
        return this.clazz.getName();
    }

    @Override
    public Class<?> getJavaClass() {
        return this.clazz;
    }

    @Override
    public String getJavascriptNamespace() {
        return this.jsNamespace;
    }

    private boolean hasSourceAnnotation(STJSBridge bridgeAnnotation) {
        return bridgeAnnotation != null && bridgeAnnotation.sources() != null && bridgeAnnotation.sources().length > 0;
    }

    @Override
    public List<URI> getJavascriptFiles() {
        STJSBridge bridgeAnnotation = ClassUtils.getAnnotation(this.clazz, STJSBridge.class);
        if (!this.hasSourceAnnotation(bridgeAnnotation)) {
            return Collections.emptyList();
        }
        ArrayList<URI> files = new ArrayList<URI>();
        for (String src : bridgeAnnotation.sources()) {
            try {
                if (src.length() <= 0) continue;
                files.add(new URI(src));
            }
            catch (URISyntaxException e) {
                throw new JavascriptClassGenerationException(this.getJavaClassName(), e);
            }
        }
        return files;
    }

    @Override
    public List<ClassWithJavascript> getDirectDependencies() {
        return Collections.emptyList();
    }

    @Override
    public Map<ClassWithJavascript, DependencyType> getDirectDependencyMap() {
        return Collections.emptyMap();
    }

    @Override
    public String getJavascriptClassName() {
        String simpleName = this.getJavaClass().getSimpleName();
        String ns = this.getJavascriptNamespace();
        if (ns != null && !ns.isEmpty()) {
            return ns + "." + simpleName;
        }
        return simpleName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clazz.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeClass other = (BridgeClass)obj;
        return this.clazz == other.clazz;
    }

    public String toString() {
        return "BridgeClass:" + this.clazz.getName();
    }
}

