/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.JavascriptClassGenerationException;
import org.stjs.generator.NamespaceUtil;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.utils.ClassUtils;
import org.stjs.generator.utils.PreConditions;

public class STJSClass
implements ClassWithJavascript {
    private static final Logger LOG = Logger.getLogger(STJSClass.class.getName());
    private static final String DEPENDENCIES_PROP = "dependencies";
    public static final String CLASS_PROP = "class";
    private static final String GENERATED_JS_FILE_PROP = "js";
    public static final String JS_NAMESPACE = "jsNamespace";
    private final Properties properties;
    private final ClassResolver classResolver;
    private Map<String, DependencyType> dependencies = Collections.emptyMap();
    private List<ClassWithJavascript> directDependencies;
    private Map<ClassWithJavascript, DependencyType> directDependenciesMap;
    private String javascriptNamespace;
    private URI generatedJavascriptFile;
    private final Class<?> javaClass;
    private final File targetFolder;

    public STJSClass(ClassResolver classResolver, File targetFolder, Class<?> javaClass) {
        PreConditions.checkNotNull(classResolver);
        PreConditions.checkNotNull(targetFolder);
        PreConditions.checkNotNull(javaClass);
        this.targetFolder = targetFolder;
        this.javaClass = javaClass;
        this.properties = new Properties();
        this.classResolver = classResolver;
        this.javascriptNamespace = null;
    }

    public STJSClass(ClassResolver classResolver, ClassLoader classLoader, Class<?> javaClass) {
        PreConditions.checkNotNull(classResolver);
        PreConditions.checkNotNull(classLoader);
        PreConditions.checkNotNull(javaClass);
        this.javaClass = javaClass;
        this.targetFolder = null;
        this.classResolver = classResolver;
        this.properties = this.loadProperties(classLoader);
        this.dependencies = this.readDependeciesProperty();
        this.generatedJavascriptFile = this.readGeneratedJavascriptFileProperty();
        this.javascriptNamespace = this.readJavascriptNamespaceProperty();
        if (this.javascriptNamespace == null) {
            this.javascriptNamespace = this.readJavascriptNamespaceAnnotation();
        }
    }

    private Properties loadProperties(ClassLoader classLoader) {
        InputStream inputStream;
        Properties props;
        block5: {
            props = new Properties();
            inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(ClassUtils.getPropertiesFileName(this.getJavaClassName()));
                if (inputStream == null) {
                    LOG.severe("CANNOT find:" + ClassUtils.getPropertiesFileName(this.getJavaClassName()) + " clazz:" + classLoader.getResource(ClassUtils.getPropertiesFileName(this.getJavaClassName())));
                    break block5;
                }
                props.load(inputStream);
            }
            catch (IOException e) {
                try {
                    throw new JavascriptClassGenerationException(this.getJavaClassName(), e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        Closeables.closeQuietly((InputStream)inputStream);
        return props;
    }

    private Map<String, DependencyType> readDependeciesProperty() {
        String depProp = this.properties.getProperty(DEPENDENCIES_PROP);
        if (depProp != null && (depProp = depProp.trim()).length() > 2) {
            String[] deps = depProp.substring(1, depProp.length() - 1).split(",");
            HashMap<String, DependencyType> depMap = new HashMap<String, DependencyType>();
            for (String dep : deps) {
                depMap.put(DependencyType.getTypeName(dep), DependencyType.getDependencyType(dep));
            }
            return depMap;
        }
        return Collections.emptyMap();
    }

    private String writeDependeciesProperty(Map<String, DependencyType> deps) {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, DependencyType> entry : deps.entrySet()) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append(DependencyType.getTypeWithPrefix(entry.getKey(), entry.getValue()));
        }
        return "[" + s.toString() + "]";
    }

    private URI readGeneratedJavascriptFileProperty() {
        String jsFile = this.properties.getProperty(GENERATED_JS_FILE_PROP);
        if (jsFile != null) {
            try {
                return new URI(jsFile);
            }
            catch (URISyntaxException e) {
                throw new JavascriptClassGenerationException(this.getJavaClassName(), "Could not load URI from " + jsFile, e);
            }
        }
        return null;
    }

    private String readJavascriptNamespaceProperty() {
        return this.properties.getProperty(JS_NAMESPACE);
    }

    private String readJavascriptNamespaceAnnotation() {
        String ns = NamespaceUtil.resolveNamespaceSimple(this.javaClass);
        if (ns == null) {
            ns = "";
        }
        return ns;
    }

    public File getStjsPropertiesFile() {
        File propFile = new File(this.targetFolder, ClassUtils.getPropertiesFileName(this.getJavaClassName()));
        if (!propFile.getParentFile().exists() && !propFile.getParentFile().mkdirs()) {
            throw new JavascriptClassGenerationException(this.getJavaClassName(), "Unable to create parent folder for the properties file:" + propFile);
        }
        return propFile;
    }

    public void store() {
        if (this.targetFolder == null) {
            throw new IllegalStateException("This properties file was open for read only");
        }
        BufferedWriter propertiesWriter = null;
        try {
            propertiesWriter = Files.newWriter((File)this.getStjsPropertiesFile(), (Charset)Charsets.UTF_8);
            this.properties.setProperty(CLASS_PROP, this.getJavaClassName());
            this.properties.store(propertiesWriter, "Generated by STJS ");
        }
        catch (IOException e1) {
            throw new JavascriptClassGenerationException(this.getJavaClassName(), "Could not open properties file " + this.getStjsPropertiesFile() + ":" + e1, e1);
        }
        finally {
            try {
                if (propertiesWriter != null) {
                    ((Writer)propertiesWriter).flush();
                    ((Writer)propertiesWriter).close();
                }
            }
            catch (IOException e) {
                throw new JavascriptClassGenerationException(this.getJavaClassName(), e);
            }
        }
    }

    public void setJavascriptNamespace(String jsNamespace) {
        this.javascriptNamespace = jsNamespace;
        this.properties.put(JS_NAMESPACE, jsNamespace);
    }

    public void setDependencies(Map<String, DependencyType> deps) {
        if (deps == null) {
            this.properties.remove(DEPENDENCIES_PROP);
            this.dependencies = new HashMap<String, DependencyType>();
        } else {
            this.dependencies = new HashMap<String, DependencyType>(deps);
            this.dependencies.remove("");
            this.properties.put(DEPENDENCIES_PROP, this.writeDependeciesProperty(this.dependencies));
        }
    }

    public void setGeneratedJavascriptFile(URI generatedJavascriptFile) {
        this.generatedJavascriptFile = generatedJavascriptFile;
        if (generatedJavascriptFile == null) {
            this.properties.remove(GENERATED_JS_FILE_PROP);
        } else {
            this.properties.put(GENERATED_JS_FILE_PROP, generatedJavascriptFile.toString());
        }
    }

    @Override
    public final String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String getJavascriptClassName() {
        String simpleName = this.getJavaClass().getSimpleName();
        String ns = this.getJavascriptNamespace();
        if (ns != null && !ns.isEmpty()) {
            return ns + "." + simpleName;
        }
        return simpleName;
    }

    @Override
    public String getJavascriptNamespace() {
        return this.javascriptNamespace;
    }

    @Override
    public List<URI> getJavascriptFiles() {
        if (this.generatedJavascriptFile == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.generatedJavascriptFile);
    }

    @Override
    public List<ClassWithJavascript> getDirectDependencies() {
        if (this.directDependencies == null) {
            this.directDependencies = new ArrayList<ClassWithJavascript>(this.dependencies.size());
            for (String depClassName : this.dependencies.keySet()) {
                this.directDependencies.add(this.classResolver.resolve(depClassName.trim()));
            }
        }
        return this.directDependencies;
    }

    @Override
    public Map<ClassWithJavascript, DependencyType> getDirectDependencyMap() {
        if (this.directDependenciesMap == null) {
            this.directDependenciesMap = new HashMap<ClassWithJavascript, DependencyType>(this.dependencies.size());
            for (Map.Entry<String, DependencyType> entry : this.dependencies.entrySet()) {
                this.directDependenciesMap.put(this.classResolver.resolve(entry.getKey().trim()), entry.getValue());
            }
        }
        return this.directDependenciesMap;
    }

    public String toString() {
        return "STJSClass [javaClassName=" + this.getJavaClassName() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getJavaClassName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        STJSClass other = (STJSClass)obj;
        return this.getJavaClassName().equals(other.getJavaClassName());
    }
}

