/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import java.io.File;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SourcePosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final int line;
    private final int column;

    public SourcePosition(File file, int beginLine, int beginColumn) {
        this.line = beginLine;
        this.column = beginColumn;
        this.file = file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourcePosition other = (SourcePosition)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.line == other.line;
    }

    public String toString() {
        return this.line + ":" + this.column;
    }
}

