/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;

public class ClassDuplicateMemberNameCheck
implements CheckContributor<ClassTree> {
    private void checkCandidate(Element overrideCandidate, ExecutableElement methodElement, TypeElement classElement, Tree member, GenerationContext<Void> context) {
        boolean isMethod = overrideCandidate instanceof ExecutableElement;
        boolean isFieldOrInnerType = !isMethod;
        String name = methodElement.getSimpleName().toString();
        if (isFieldOrInnerType) {
            context.addError(member, "There is already a field with the same name as this method in the type or one of its parents: " + ((TypeElement)overrideCandidate.getEnclosingElement()).getQualifiedName() + "." + overrideCandidate.getSimpleName());
        } else if (!context.getElements().overrides(methodElement, (ExecutableElement)overrideCandidate, classElement)) {
            context.addError(member, "Only maximum one method with the name [" + name + "] is allowed to have a body. The other methods must be marked as native." + " The type (or one of its parents) may contain already the method: " + overrideCandidate + " that has a different signature");
        }
    }

    private void checkMethodName(TypeElement classElement, MethodTree method, ExecutableElement methodElement, GenerationContext<Void> context, Multimap<String, Element> existingNames) {
        String name = method.getName().toString();
        Collection sameName = existingNames.get((Object)name);
        if (sameName.isEmpty()) {
            existingNames.put((Object)name, (Object)methodElement);
        } else {
            for (Element overrideCandidate : sameName) {
                this.checkCandidate(overrideCandidate, methodElement, classElement, method, context);
            }
        }
    }

    private void checkMethod(TypeElement classElement, Tree member, GenerationContext<Void> context, Multimap<String, Element> existingNames) {
        if (member instanceof MethodTree) {
            MethodTree method = (MethodTree)member;
            ExecutableElement methodElement = TreeUtils.elementFromDeclaration(method);
            if (JavaNodes.isNative(methodElement)) {
                return;
            }
            TreeWrapper<Tree, Void> tw = context.getCurrentWrapper().child(member);
            if (MemberWriters.shouldSkip(tw)) {
                return;
            }
            if (methodElement.getKind() != ElementKind.METHOD) {
                return;
            }
            this.checkMethodName(classElement, method, methodElement, context, existingNames);
        }
    }

    private boolean hasOnlyFields(Collection<Element> sameName) {
        for (Element el : sameName) {
            if (el instanceof VariableElement) continue;
            return false;
        }
        return true;
    }

    private void checkField(Tree member, GenerationContext<Void> context, Multimap<String, Element> existingNames) {
        if (member instanceof VariableTree) {
            TreeWrapper<Tree, Void> tw = context.getCurrentWrapper().child(member);
            if (MemberWriters.shouldSkip(tw)) {
                return;
            }
            String name = ((VariableTree)member).getName().toString();
            Collection sameName = existingNames.get((Object)name);
            if (sameName.isEmpty()) {
                VariableElement variableElement = TreeUtils.elementFromDeclaration((VariableTree)member);
                existingNames.put((Object)name, (Object)variableElement);
            } else if (!this.hasOnlyFields(sameName)) {
                context.addError(member, "The type (or one of its parents) contains already a method called [" + name + "]. Javascript cannot distinguish methods/fields with the same name");
            }
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        LinkedListMultimap names = LinkedListMultimap.create();
        TypeElement classElement = (TypeElement)context.getTrees().getElement(context.getCurrentPath());
        TypeMirror superType = classElement.getSuperclass();
        if (superType.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superType).asElement();
            for (Element element : context.getElements().getAllMembers(superclassElement)) {
                if (JavaNodes.isNative(element)) continue;
                names.put((Object)element.getSimpleName().toString(), (Object)element);
            }
        }
        for (Tree tree2 : tree.getMembers()) {
            this.checkMethod(classElement, tree2, context, (Multimap<String, Element>)names);
        }
        for (Tree tree3 : tree.getMembers()) {
            this.checkField(tree3, context, (Multimap<String, Element>)names);
        }
        return null;
    }
}

