/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeWrapper;

public class ClassForbidExtendsSyntheticTypeCheck
implements CheckContributor<ClassTree> {
    private void checkInterface(TreeWrapper<Tree, Void> iface) {
        if (iface.isSyntheticType()) {
            iface.addError("You cannot implement an interface that is marked as synthetic (@SyntheticType)");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        TypeElement element = (TypeElement)tw.getElement();
        if (element.getNestingKind() == NestingKind.ANONYMOUS) {
            return null;
        }
        if (tree.getExtendsClause() != null && tw.child(tree.getExtendsClause()).isSyntheticType()) {
            context.addError(tree, "You cannot extend from a class that is marked as synthetic (@SyntheticType)");
        }
        for (Tree tree2 : tree.getImplementsClause()) {
            this.checkInterface(tw.child(tree2));
        }
        return null;
    }
}

