/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Element;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.utils.JavaNodes;

public class ClassGlobalInstanceMembersCheck
implements CheckContributor<ClassTree> {
    private void checkMember(Tree member, GenerationContext<Void> context) {
        if (member instanceof BlockTree || InternalUtils.isSyntheticConstructor(member)) {
            return;
        }
        Element memberElement = JavaNodes.elementFromDeclaration(member);
        if (!JavaNodes.isStatic(memberElement)) {
            context.addError(member, "Only static constructions can be used in a @GlobalScope class");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (!tw.isGlobal()) {
            return null;
        }
        for (Tree tree2 : tree.getMembers()) {
            this.checkMember(tree2, context);
        }
        return null;
    }
}

