/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeWrapper;

public class ClassImplementJavascriptFunctionCheck
implements CheckContributor<ClassTree> {
    private void checkInteface(TreeWrapper<Tree, Void> iface) {
        if (iface.isJavaScriptFunction()) {
            iface.addError("You cannot implement intefaces annotated with @JavascriptFunction. You can only have inline object creation with this type of interfaces");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        TreeWrapper<Tree, Void> superType;
        if (tree.getSimpleName().toString().isEmpty()) {
            return null;
        }
        TreeWrapper tw = context.getCurrentWrapper();
        for (Tree tree2 : tree.getImplementsClause()) {
            this.checkInteface(tw.child(tree2));
        }
        if (tree.getExtendsClause() != null && (superType = tw.child(tree.getExtendsClause())).isJavaScriptFunction()) {
            superType.addError("You cannot extend intefaces annotated with @JavascriptFunction. You can only have inline object creation with this type of interfaces");
        }
        return null;
    }
}

