/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;

public class FieldInitializerCheck
implements CheckContributor<VariableTree> {
    private boolean checkInitializer(VariableTree tree) {
        if (tree.getInitializer() == null) {
            return true;
        }
        if (tree.getInitializer() instanceof LiteralTree) {
            return true;
        }
        return tree.getInitializer() instanceof UnaryTree && ((UnaryTree)tree.getInitializer()).getExpression() instanceof LiteralTree;
    }

    @Override
    public Void visit(CheckVisitor visitor, VariableTree tree, GenerationContext<Void> context) {
        VariableElement element = TreeUtils.elementFromDeclaration(tree);
        if (element.getKind() != ElementKind.FIELD) {
            return null;
        }
        TreeWrapper tw = context.getCurrentWrapper();
        if (MemberWriters.shouldSkip(tw)) {
            return null;
        }
        if (JavaNodes.isStatic(element)) {
            return null;
        }
        if (this.checkInitializer(tree)) {
            return null;
        }
        if (!JavaNodes.isJavaScriptPrimitive(context.getTrees().getTypeMirror(context.getCurrentPath()))) {
            context.addError(tree, "Instance field inline initialization is allowed only for string and number field types");
            return null;
        }
        context.addError(tree, "Instance field inline initialization can only done with literal constants");
        return null;
    }
}

