/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.MethodTree;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.javascript.annotation.ServerSide;

public class MethodOverloadCheck
implements CheckContributor<MethodTree> {
    private static boolean isMoreGenericVarArg(GenerationContext<Void> context, ExecutableElement more, ExecutableElement less) {
        TypeMirror moreType = ((ArrayType)more.getParameters().get(0).asType()).getComponentType();
        for (int p = 0; p < less.getParameters().size(); ++p) {
            TypeMirror lessType = less.getParameters().get(p).asType();
            if (context.getTypes().isAssignable(lessType, moreType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMoreGenericNormalArgs(GenerationContext<Void> context, ExecutableElement more, ExecutableElement less) {
        for (int p = 0; p < less.getParameters().size(); ++p) {
            TypeMirror lessType = less.getParameters().get(p).asType();
            TypeMirror moreType = more.getParameters().get(p).asType();
            if (context.getTypes().isAssignable(lessType, moreType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMoreGeneric(GenerationContext<Void> context, ExecutableElement more, ExecutableElement less, boolean hasVarArgs) {
        if (more.equals(less)) {
            return true;
        }
        if (hasVarArgs) {
            return MethodOverloadCheck.isMoreGenericVarArg(context, more, less);
        }
        if (less.getParameters().size() > more.getParameters().size()) {
            return false;
        }
        return MethodOverloadCheck.isMoreGenericNormalArgs(context, more, less);
    }

    private void checkMember(Element memberElement, ExecutableElement methodElement, MethodTree tree, GenerationContext<Void> context, boolean hasVarArgs) {
        if (methodElement.equals(memberElement)) {
            return;
        }
        if (!memberElement.getSimpleName().equals(methodElement.getSimpleName()) || memberElement.getKind() != methodElement.getKind()) {
            return;
        }
        if (!MethodOverloadCheck.isMoreGeneric(context, methodElement, (ExecutableElement)memberElement, hasVarArgs)) {
            context.addError(tree, "There is a method in the class (or one of its parents) having the same name with the method named [" + tree.getName() + "] but is less generic");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, MethodTree tree, GenerationContext<Void> context) {
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration(tree);
        if (JavaNodes.isNative(methodElement)) {
            return null;
        }
        TreeWrapper tw = context.getCurrentWrapper();
        if (MemberWriters.shouldSkip(tw)) {
            return null;
        }
        boolean hasVarArgs = tree.getParameters().size() == 1 && InternalUtils.isVarArg(tree.getParameters().get(0));
        TypeElement typeElement = (TypeElement)methodElement.getEnclosingElement();
        List<? extends Element> allMembers = methodElement.getKind() == ElementKind.CONSTRUCTOR ? typeElement.getEnclosedElements() : context.getElements().getAllMembers(typeElement);
        for (Element element : allMembers) {
            if (element.getAnnotation(ServerSide.class) != null) continue;
            this.checkMember(element, methodElement, tree, context, hasVarArgs);
        }
        return null;
    }
}

