/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.utils.JavaNodes;

public class IdentifierAccessOuterScopeCheck
implements CheckContributor<IdentifierTree> {
    private static boolean isInsideInizializerBlock(TreePath path) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            if (p.getLeaf() instanceof BlockTree && p.getParentPath().getLeaf() instanceof ClassTree) {
                return true;
            }
            if (!(p.getLeaf() instanceof MethodTree)) continue;
            return false;
        }
        return false;
    }

    public static ClassTree enclosingClassSkipAnonymousInitializer(TreePath path) {
        TreePath outerClassTreePath;
        TreePath enclosingClassTreePath = TreeUtils.enclosingPathOfType(path, ClassTree.class);
        if (IdentifierAccessOuterScopeCheck.isInsideInizializerBlock(path) && (outerClassTreePath = TreeUtils.enclosingPathOfType(enclosingClassTreePath.getParentPath(), ClassTree.class)) != null) {
            enclosingClassTreePath = outerClassTreePath;
        }
        return (ClassTree)enclosingClassTreePath.getLeaf();
    }

    public static boolean isOuterType(GenerationContext<Void> context, TypeElement outerType, TypeElement subType) {
        TypeMirror subTypeErasure = context.getTypes().erasure(subType.asType());
        if (!(subTypeErasure instanceof DeclaredType)) {
            return false;
        }
        TypeMirror outerTypeErasure = context.getTypes().erasure(outerType.asType());
        TypeMirror type = ((DeclaredType)subTypeErasure).getEnclosingType();
        while (type != null) {
            if (IdentifierAccessOuterScopeCheck.isSameType(type, outerTypeErasure)) {
                return true;
            }
            if (!(type instanceof DeclaredType)) {
                return false;
            }
            type = ((DeclaredType)type).getEnclosingType();
        }
        return false;
    }

    private static boolean isSameType(TypeMirror type1, TypeMirror type2) {
        return type1.toString().equals(type2.toString());
    }

    public static boolean isRegularInstanceField(Element fieldElement, IdentifierTree tree) {
        if (fieldElement == null || fieldElement.getKind() != ElementKind.FIELD) {
            return false;
        }
        if (JavaNodes.isStatic(fieldElement)) {
            return false;
        }
        return !"this".equals(tree.getName().toString()) && !"super".equals(tree.getName().toString());
    }

    @Override
    public Void visit(CheckVisitor visitor, IdentifierTree tree, GenerationContext<Void> context) {
        Element fieldElement = TreeUtils.elementFromUse(tree);
        if (!IdentifierAccessOuterScopeCheck.isRegularInstanceField(fieldElement, tree)) {
            return null;
        }
        ClassTree enclosingClassTree = IdentifierAccessOuterScopeCheck.enclosingClassSkipAnonymousInitializer(context.getCurrentPath());
        TypeElement currentScopeClassElement = TreeUtils.elementFromDeclaration(enclosingClassTree);
        TypeElement fieldOwnerElement = (TypeElement)fieldElement.getEnclosingElement();
        if (IdentifierAccessOuterScopeCheck.isOuterType(context, fieldOwnerElement, currentScopeClassElement)) {
            context.addError(tree, "In Javascript you cannot access a field from the outer type. You should define a variable var that=this outside your function definition and use the property of this object. The field: " + tree);
        }
        return null;
    }
}

