/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.check.expression.IdentifierAccessOuterScopeCheck;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.expression.MethodInvocationWriter;

public class MethodInvocationOuterScopeCheck
implements CheckContributor<MethodInvocationTree> {
    private void checkScope(Element methodElement, MethodInvocationTree tree, GenerationContext<Void> context) {
        ClassTree enclosingClassTree = IdentifierAccessOuterScopeCheck.enclosingClassSkipAnonymousInitializer(context.getCurrentPath());
        TypeElement currentScopeClassElement = TreeUtils.elementFromDeclaration(enclosingClassTree);
        TypeElement methodOwnerElement = (TypeElement)methodElement.getEnclosingElement();
        if (IdentifierAccessOuterScopeCheck.isOuterType(context, methodOwnerElement, currentScopeClassElement)) {
            context.addError(tree, "In Javascript you cannot call methods or fields from the outer type. You should define a variable var that=this outside your function definition and call the methods on this object");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, MethodInvocationTree tree, GenerationContext<Void> context) {
        ExecutableElement methodElement = TreeUtils.elementFromUse(tree);
        if (JavaNodes.isStatic(methodElement)) {
            return null;
        }
        String name = MethodInvocationWriter.buildMethodName(tree);
        if ("this".equals(name) || "super".equals(name)) {
            return null;
        }
        if (!(tree.getMethodSelect() instanceof IdentifierTree)) {
            return null;
        }
        this.checkScope(methodElement, tree, context);
        return null;
    }
}

