/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.utils.JavaNodes;

public class NewClassInlineFunctionCheck
implements CheckContributor<NewClassTree> {
    private boolean checkMember(Tree member, GenerationContext<Void> context, boolean hasMethod) {
        Element memberElement = JavaNodes.elementFromDeclaration(member);
        if (memberElement.getKind() == ElementKind.METHOD && !hasMethod) {
            return true;
        }
        if (InternalUtils.isSynthetic(member)) {
            return false;
        }
        context.addError(member, "Initialization block for a Javascript function must contain exactly one method");
        return false;
    }

    @Override
    public Void visit(CheckVisitor visitor, NewClassTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (!tw.child(tree.getIdentifier()).isJavaScriptFunction()) {
            return null;
        }
        boolean hasMethod = false;
        for (Tree tree2 : tree.getClassBody().getMembers()) {
            hasMethod = this.checkMember(tree2, context, hasMethod);
        }
        return null;
    }
}

