/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.executor;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.stjs.generator.executor.ExecutionResult;

public class RhinoExecutor {
    private Object addScript(ScriptEngine engine, File scriptFile) throws ScriptException {
        BufferedReader input = null;
        try {
            input = Files.newReader((File)scriptFile, (Charset)Charsets.UTF_8);
            Object object = engine.eval(input);
            return object;
        }
        catch (FileNotFoundException e) {
            throw new ScriptException(e);
        }
        finally {
            Closeables.closeQuietly((Reader)input);
        }
    }

    public ExecutionResult run(Collection<File> srcFiles, boolean mainClassDisabled) throws ScriptException {
        ExecutionResult executionResult;
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("stjs.js"), "UTF-8");
            engine.eval(reader);
            if (mainClassDisabled) {
                engine.eval("stjs.mainCallDisabled=true;");
            }
            Object result = null;
            for (File srcFile : srcFiles) {
                result = this.addScript(engine, srcFile);
            }
            executionResult = new ExecutionResult(result, null, null, 0);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ScriptException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return executionResult;
    }
}

