/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javac;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.stjs.generator.javac.CustomJavaFileObject;
import org.stjs.generator.javac.PackageInternalsFinder;

public class CustomClassloaderJavaFileManager
implements JavaFileManager {
    private final ClassLoader classLoader;
    private final StandardJavaFileManager standardFileManager;
    private final PackageInternalsFinder finder;

    @SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="harmless")
    public CustomClassloaderJavaFileManager(ClassLoader classLoader, StandardJavaFileManager standardFileManager) {
        this.classLoader = new URLClassLoader(new URL[0], classLoader);
        this.standardFileManager = standardFileManager;
        this.finder = new PackageInternalsFinder(this.classLoader);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_PATH) {
            return this.classLoader;
        }
        return this.standardFileManager.getClassLoader(location);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)file).binaryName();
        }
        return this.standardFileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.standardFileManager.list(location, packageName, kinds, recurse);
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            if (packageName.startsWith("java.")) {
                return this.standardFileManager.list(location, packageName, kinds, recurse);
            }
            return this.finder.find(packageName, recurse);
        }
        return Collections.emptyList();
    }

    @Override
    public int isSupportedOption(String option) {
        return -1;
    }
}

