/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javascript.rhino;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.stjs.generator.javascript.rhino.AstVisitor;
import org.stjs.generator.javascript.rhino.CodeFragment;
import org.stjs.generator.javascript.rhino.Statements;

@SuppressWarnings(justification="The type check is done by looking in the map", value={"BC_UNCONFIRMED_CAST"})
public class RhinoNodeVisitorSupport {
    private static Map<Class<?>, Caller> callers = new HashMap();

    public <T> void accept(Node node, AstVisitor<T> visitor, T param) {
        Caller caller = callers.get(node.getClass());
        if (caller != null) {
            caller.call(node, visitor, param);
        }
    }

    private static void addCaller(Class<?> nodeClass, Caller caller) {
        callers.put(nodeClass, caller);
    }

    static {
        RhinoNodeVisitorSupport.addCaller(Name.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitName((Name)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(Label.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitLabel((Label)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(Block.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitBlock((Block)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ElementGet.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitElementGet((ElementGet)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(NewExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitNewExpression((NewExpression)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ArrayLiteral.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitArrayLiteral((ArrayLiteral)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(StringLiteral.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitStringLiteral((StringLiteral)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ParenthesizedExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitParenthesizedExpression((ParenthesizedExpression)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(BreakStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitBreakStatemen((BreakStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(SwitchCase.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitSwitchCase((SwitchCase)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(CatchClause.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitCatchClause((CatchClause)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ContinueStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitContinueStatement((ContinueStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(FunctionNode.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitFunctionNode((FunctionNode)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ObjectProperty.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitObjectProperty((ObjectProperty)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ObjectLiteral.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitObjectLiteral((ObjectLiteral)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(DoLoop.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitDoLoop((DoLoop)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(EmptyStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitEmptyStatement((EmptyStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ForInLoop.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitForInLoop((ForInLoop)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ForLoop.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitForLoop((ForLoop)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(IfStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitIfStatement((IfStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(LabeledStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitLabeledStatement((LabeledStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ReturnStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitReturnStatement((ReturnStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(SwitchStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitSwitchStatement((SwitchStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(FunctionCall.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitFunctionCall((FunctionCall)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(PropertyGet.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitPropertyGet((PropertyGet)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(VariableDeclaration.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitVariableDeclaration((VariableDeclaration)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(VariableInitializer.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitVariableInitializer((VariableInitializer)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(TryStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitTryStatement((TryStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(WhileLoop.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitWhileLoop((WhileLoop)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(AstRoot.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitAstRoot((AstRoot)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ConditionalExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitConditionalExpression((ConditionalExpression)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(NumberLiteral.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitNumberLitera((NumberLiteral)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(Statements.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitStatements((Statements)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(Assignment.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitAssignment((Assignment)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(InfixExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitInfixExpression((InfixExpression)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(KeywordLiteral.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitKeywordLiteral((KeywordLiteral)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(UnaryExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitUnaryExpression((UnaryExpression)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ExpressionStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitExpressionStatement((ExpressionStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(ThrowStatement.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitThrowStatement((ThrowStatement)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(CodeFragment.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitCodeFragment((CodeFragment)node, param);
            }
        });
        RhinoNodeVisitorSupport.addCaller(EmptyExpression.class, new Caller(){

            @Override
            public <T> void call(Node node, AstVisitor<T> visitor, T param) {
                visitor.visitEmptyExpression((EmptyExpression)node, param);
            }
        });
    }

    private static interface Caller {
        public <T> void call(Node var1, AstVisitor<T> var2, T var3);
    }
}

