/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.name;

public enum DependencyType {
    EXTENDS(""),
    STATIC("s"),
    OTHER("o");

    private final String prefix;

    private DependencyType(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static String getTypeName(String typeWithPrefix) {
        if (typeWithPrefix == null || typeWithPrefix.isEmpty()) {
            return typeWithPrefix;
        }
        int pos = typeWithPrefix.indexOf(58);
        return pos < 0 ? typeWithPrefix : typeWithPrefix.substring(pos + 1);
    }

    public static DependencyType getDependencyType(String typeWithPrefix) {
        if (typeWithPrefix == null || typeWithPrefix.isEmpty()) {
            return EXTENDS;
        }
        int pos = typeWithPrefix.indexOf(58);
        if (pos < 0) {
            return EXTENDS;
        }
        if (typeWithPrefix.charAt(0) == DependencyType.STATIC.prefix.charAt(0)) {
            return STATIC;
        }
        return OTHER;
    }

    public static String getTypeWithPrefix(String typeName, DependencyType depType) {
        if (typeName == null || typeName.isEmpty()) {
            return typeName;
        }
        if (depType == EXTENDS) {
            return typeName;
        }
        return depType.prefix + ":" + typeName;
    }

    public boolean isStricter(DependencyType otherType) {
        return this.ordinal() < otherType.ordinal();
    }
}

