/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.utils;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.script.ScriptException;
import org.junit.Assert;
import org.stjs.generator.BridgeClass;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.DependencyCollector;
import org.stjs.generator.GenerationDirectory;
import org.stjs.generator.Generator;
import org.stjs.generator.GeneratorConfiguration;
import org.stjs.generator.GeneratorConfigurationBuilder;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.executor.ExecutionResult;
import org.stjs.generator.executor.RhinoExecutor;
import org.stjs.generator.utils.LazyGenerationClassResolver;
import org.stjs.generator.utils.Timers;
import org.stjs.javascript.Array;
import org.stjs.javascript.Date;
import org.stjs.javascript.JSCollections;
import org.stjs.javascript.Map;

public abstract class AbstractStjsTest {
    private static final String TEMP_GENERATION_PATH = "temp-generated-js";
    private Generator generator;
    private static final int CALL_METHOD_ARG_COUNT = 3;
    private static final int ARRAY_GET_METHOD_ARG_COUNT = 2;
    private static final int CALL_MEMBER_METHOD_ARG_COUNT = 2;
    private static final int PAD = 5;

    public String generate(Class<?> clazz) {
        return (String)this.executeOrGenerate(clazz, false, false);
    }

    public String generate(Class<?> clazz, GeneratorConfiguration config) {
        return (String)this.executeOrGenerate(clazz, false, false, config);
    }

    public String generateWithSourcemap(Class<?> clazz) {
        return (String)this.executeOrGenerate(clazz, false, true);
    }

    public Object execute(Class<?> clazz) {
        return this.convert(this.executeOrGenerate(clazz, true, false));
    }

    public double executeAndReturnNumber(Class<?> clazz) {
        return this.executeAndReturnNumber(clazz, null);
    }

    public double executeAndReturnNumber(Class<?> clazz, GeneratorConfiguration extraConfig) {
        Object obj = this.convert(this.executeOrGenerate(clazz, true, false, extraConfig));
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return Double.NaN;
    }

    public Object execute(String preGeneratedJs) {
        try {
            File jsfile = new File(preGeneratedJs);
            ExecutionResult execResult = new RhinoExecutor().run(Collections.singletonList(jsfile), false);
            return this.convert(execResult.getResult());
        }
        catch (ScriptException se) {
            throw new RuntimeException(se);
        }
    }

    private Object convert(Object result) {
        if (result == null) {
            return null;
        }
        if (result.getClass().getName().contains("NativeObject")) {
            return this.convertToMap(result);
        }
        if (result.getClass().getName().contains("NativeArray")) {
            return this.convertToArray(result);
        }
        if (result.getClass().getName().contains("NativeDate")) {
            return this.convertToDate(result);
        }
        if (result.getClass().getName().contains("ScriptObjectMirror")) {
            return this.convertScriptObject(result);
        }
        return result;
    }

    private Object invoke(Object obj, String method, int argCount, Object ... args) {
        try {
            for (Method m : obj.getClass().getMethods()) {
                if (!m.getName().equals(method) || m.getParameterTypes().length != argCount) continue;
                return m.invoke(obj, args);
            }
            throw new STJSRuntimeException("Method " + method + " not found in class " + obj.getClass());
        }
        catch (InvocationTargetException e) {
            throw new STJSRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new STJSRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new STJSRuntimeException(e);
        }
    }

    private Object convertToDate(Object result) {
        Double time = (Double)this.invoke(result, "callMethod", 3, result, "getTime", null);
        return new Date((double)time.longValue());
    }

    private Array<Object> convertToArray(Object result) {
        Array js = JSCollections.$array((Object[])new Object[0]);
        long length = (Long)this.invoke(result, "getLength", 0, new Object[0]);
        int i = 0;
        while ((long)i < length) {
            Object value = this.invoke(result, "get", 2, i, null);
            js.push(new Object[]{this.convert(value)});
            ++i;
        }
        return js;
    }

    private Map<String, Object> convertToMap(Object result) {
        Object[] ids;
        Map js = JSCollections.$map();
        for (Object key : ids = (Object[])this.invoke(result, "getIds", 0, new Object[0])) {
            Object value = this.invoke(result, "get", 2, key.toString(), null);
            js.$put(key.toString(), this.convert(value));
        }
        return js;
    }

    private Object convertScriptObject(Object result) {
        String cls = (String)this.invoke(result, "getClassName", 0, new Object[0]);
        if ("Date".equals(cls)) {
            Double time = (Double)this.invoke(result, "callMember", 2, "getTime", null);
            return new Date((double)time.longValue());
        }
        Map js = JSCollections.$map();
        Set ids = (Set)this.invoke(result, "keySet", 0, new Object[0]);
        for (String key : ids) {
            Object value = this.invoke(result, "get", 1, key);
            js.$put(key, this.convert(value));
        }
        return js;
    }

    private Object executeOrGenerate(Class<?> clazz, boolean execute, boolean withSourceMap) {
        return this.executeOrGenerate(clazz, execute, withSourceMap, null);
    }

    private Object executeOrGenerate(Class<?> clazz, boolean execute, boolean withSourceMap, GeneratorConfiguration extraConfig) {
        File generationPath = new File("target", TEMP_GENERATION_PATH);
        if (!generationPath.exists() && !generationPath.mkdirs()) {
            throw new STJSRuntimeException("Unable to create generation directory");
        }
        GenerationDirectory generationFolder = new GenerationDirectory(generationPath, new File(TEMP_GENERATION_PATH), generationPath.toURI());
        final File sourcePath = new File("src/test/java");
        File resourcePath = new File("src/test/resources");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        GeneratorConfiguration config = new GeneratorConfigurationBuilder(extraConfig).allowedPackage("org.stjs.javascript").allowedPackage("org.stjs.generator").allowedPackage(clazz.getPackage().getName()).generateSourceMap(withSourceMap).stjsClassLoader(classLoader).generationFolder(generationFolder).targetFolder(new File("target", "test-classes")).classResolver(new LazyGenerationClassResolver(classLoader, new LazyGenerationClassResolver.LazyGenerator(){

            @Override
            public ClassWithJavascript generateJavaScript(String className) {
                return AbstractStjsTest.this.generator.generateJavascript(className, sourcePath);
            }
        })).build();
        this.generator = new Generator(config);
        ClassWithJavascript stjsClass = this.generator.generateJavascript(clazz.getName(), sourcePath);
        Timers.start("js-exec");
        ArrayList<File> javascriptFiles = new ArrayList<File>();
        try {
            Object object;
            File jsFile = new File(stjsClass.getJavascriptFiles().get(0).getPath());
            String content = Files.toString((File)jsFile, (Charset)Charset.defaultCharset());
            List<ClassWithJavascript> allDeps = new DependencyCollector().orderAllDependencies(stjsClass);
            for (ClassWithJavascript dep : allDeps) {
                for (URI js : dep.getJavascriptFiles()) {
                    if (dep instanceof BridgeClass) {
                        javascriptFiles.add(new File(resourcePath, js.getPath()));
                        continue;
                    }
                    javascriptFiles.add(new File(js.getPath()));
                }
            }
            ExecutionResult execResult = new RhinoExecutor().run(javascriptFiles, !execute);
            if (execute) {
                object = execResult.getResult();
                return object;
            }
            object = content;
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ScriptException ex) {
            for (File file : javascriptFiles) {
                this.displayWithLines(file);
            }
            throw new STJSRuntimeException(ex);
        }
        finally {
            Timers.end("js-exec");
        }
    }

    public ClassWithJavascript stjsClass(Class<?> clazz) {
        return this.generator.getExistingStjsClass(Thread.currentThread().getContextClassLoader(), clazz);
    }

    public void assertCodeContains(Class<?> clazz, String snippet) {
        this.assertCodeContains(this.generate(clazz), snippet);
    }

    public void assertCodeContains(Class<?> clazz, String snippet, GeneratorConfiguration extraConfig) {
        this.assertCodeContains(this.generate(clazz, extraConfig), snippet);
    }

    public void assertCodeContains(String code, String snippet) {
        String cleanCode = code.replaceAll("\\s+", "");
        String cleanSnippet = snippet.replaceAll("\\s+", "");
        Assert.assertTrue((String)("[" + snippet + "] not in \n" + code), (boolean)cleanCode.contains(cleanSnippet));
    }

    public void assertCodeDoesNotContain(Class<?> clazz, String snippet) {
        this.assertCodeDoesNotContain(this.generate(clazz), snippet);
    }

    public void assertCodeDoesNotContain(Class<?> clazz, String snippet, GeneratorConfiguration extraConfig) {
        this.assertCodeDoesNotContain(this.generate(clazz, extraConfig), snippet);
    }

    public void assertCodeDoesNotContain(String code, String snippet) {
        String cleanCode = code.replaceAll("\\s+", "");
        String cleanSnippet = snippet.replaceAll("\\s+", "");
        Assert.assertTrue((String)("[" + snippet + "] in \n" + code), (!cleanCode.contains(cleanSnippet) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void displayWithLines(File file) {
        block8: {
            BufferedReader in = null;
            try {
                System.out.println("//---" + file);
                in = Files.newReader((File)file, (Charset)Charset.defaultCharset());
                int lineNo = 1;
                String line = null;
                while ((line = in.readLine()) != null) {
                    System.out.print(Strings.padEnd((String)(lineNo + ""), (int)5, (char)' '));
                    System.out.println(line);
                    ++lineNo;
                }
                Closeables.closeQuietly((Reader)in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closeables.closeQuietly(in);
            }
        }
    }

    @SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="this is for tests only")
    public ClassLoader buildClassLoader() {
        File generationPath = new File("target", TEMP_GENERATION_PATH);
        try {
            URL[] urls = new URL[]{generationPath.toURI().toURL()};
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

