/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.utils;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import org.stjs.generator.JavascriptClassGenerationException;
import org.stjs.javascript.annotation.STJSBridge;

public final class ClassUtils {
    private static final Pattern IMPLICIT_BRIDGE = Pattern.compile("java\\.lang.*|org\\.junit.*");

    private ClassUtils() {
    }

    public static Class<?> getClazz(ClassLoader builtProjectClassLoader, String className) {
        try {
            return builtProjectClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JavascriptClassGenerationException(className, "Cannot load class:" + e);
        }
    }

    public static boolean isBridge(ClassLoader builtProjectClassLoader, Class<?> clazz) {
        boolean ok = ClassUtils.hasAnnotation(clazz, ClassUtils.getClazz(builtProjectClassLoader, STJSBridge.class.getName()));
        if (ok) {
            return ok;
        }
        return IMPLICIT_BRIDGE.matcher(clazz.getName()).matches();
    }

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ClassUtils.getAnnotation(clazz, annotationClass) != null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz == null) {
            return null;
        }
        T ann = clazz.getAnnotation(annotationClass);
        if (ann != null) {
            return ann;
        }
        if (clazz.getPackage() == null) {
            return null;
        }
        return clazz.getPackage().getAnnotation(annotationClass);
    }

    public static String getPropertiesFileName(String className) {
        return className.replace('.', '/') + ".stjs";
    }
}

