/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.stjs.generator.GenerationContext;

public final class JavascriptKeywords {
    public static final String PROTOTYPE = "prototype";
    public static final String CONSTRUCTOR = "constructor";
    public static final String VAR = "var";
    public static final String THIS = "this";
    public static final String NULL = "null";
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"));

    private JavascriptKeywords() {
    }

    public static void checkIdentifier(Tree tree, String name, GenerationContext<?> context) {
        if (KEYWORDS.contains(name)) {
            context.addError(tree, "Wrong usage of Javascript keyword:" + name);
        }
    }

    public static boolean isReservedWord(String identifier) {
        return KEYWORDS.contains(identifier);
    }
}

