/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.statement;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.statement.MultipleVariableWriter;

public class BlockWriter<JS>
implements WriterContributor<BlockTree, JS> {
    private final MultipleVariableWriter<JS> multipleVariableWriter = new MultipleVariableWriter();

    @Override
    public JS visit(WriterVisitor<JS> visitor, BlockTree tree, GenerationContext<JS> context) {
        int i = 0;
        JavaScriptBuilder<JS> js = context.js();
        List<? extends StatementTree> statements = tree.getStatements();
        ArrayList<Object> jsStatements = new ArrayList<Object>(statements.size());
        while (i < statements.size()) {
            int sameLineVars = this.sameLineVars(i, statements, context);
            Object jsNodes = null;
            if (sameLineVars == 1) {
                jsNodes = visitor.scan((Tree)statements.get(i++), context);
            } else {
                jsNodes = this.multipleVariableWriter.visit(visitor, statements.subList(i, i + sameLineVars), context, true);
                i += sameLineVars;
            }
            jsStatements.add(jsNodes);
        }
        JS block = js.block(jsStatements);
        if (tree.isStatic()) {
            JS function = js.function(null, Collections.emptyList(), block);
            block = js.functionCall(js.paren(function), Collections.emptyList());
            block = js.expressionStatement(block);
        }
        return context.withPosition(tree, block);
    }

    private int sameLineVars(int start, List<? extends StatementTree> statements, GenerationContext<JS> context) {
        if (!(statements.get(start) instanceof VariableTree)) {
            return 1;
        }
        int line = context.getStartLine(statements.get(start));
        int same = 1;
        for (int i = start + 1; i < statements.size() && statements.get(i) instanceof VariableTree && context.getStartLine(statements.get(i)) == line; ++i) {
            ++same;
        }
        return same;
    }
}

