/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.ExecutableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javascript.AssignOperator;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.expression.MethodInvocationWriter;

public class MethodToPropertyTemplate<JS>
implements WriterContributor<MethodInvocationTree, JS> {
    @Override
    public JS visit(WriterVisitor<JS> visitor, MethodInvocationTree tree, GenerationContext<JS> context) {
        int argCount = tree.getArguments().size();
        if (argCount > 2) {
            throw context.addError(tree, "A 'toProperty' template can only be applied for methods with 0 or 1 parameters");
        }
        Object target = null;
        int arg = 0;
        ExecutableElement methodElement = TreeUtils.elementFromUse(tree);
        target = JavaNodes.isStatic(methodElement) ? (Object)context.js().paren(visitor.scan((Tree)tree.getArguments().get(arg++), context)) : (Object)MethodInvocationWriter.buildTarget(visitor, context.getCurrentWrapper());
        Object property = context.js().property(target, MethodToPropertyTemplate.getPropertyName(tree));
        if (argCount == arg) {
            return (JS)property;
        }
        return context.js().assignment(AssignOperator.ASSIGN, property, visitor.scan((Tree)tree.getArguments().get(arg), context));
    }

    public static String getPropertyName(MethodInvocationTree tree) {
        String name = MethodInvocationWriter.buildMethodName(tree);
        int start = name.startsWith("$") ? 1 : 0;
        return name.substring(start);
    }
}

