/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.synchronoss.cpo.jdbc.JavaSqlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSqlTypes
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static JavaSqlType<?>[] jdbcTypes = new JavaSqlType[]{new JavaSqlType<String>(1, "CHAR", String.class), new JavaSqlType<String>(-1, "LONGVARCHAR", String.class), new JavaSqlType<String>(12, "VARCHAR", String.class), new JavaSqlType<BigDecimal>(3, "DECIMAL", BigDecimal.class), new JavaSqlType<BigDecimal>(2, "NUMERIC", BigDecimal.class), new JavaSqlType<Byte>(-6, "TINYINT", Byte.TYPE), new JavaSqlType<Short>(5, "SMALLINT", Short.TYPE), new JavaSqlType<Integer>(4, "INTEGER", Integer.TYPE), new JavaSqlType<Long>(-5, "BIGINT", Long.TYPE), new JavaSqlType<Float>(7, "REAL", Float.TYPE), new JavaSqlType<Double>(6, "FLOAT", Double.TYPE), new JavaSqlType<Double>(8, "DOUBLE", Double.TYPE), new JavaSqlType<byte[]>(-2, "BINARY", byte[].class), new JavaSqlType<byte[]>(-3, "VARBINARY", byte[].class), new JavaSqlType<byte[]>(-4, "LONGVARBINARY", byte[].class), new JavaSqlType<Date>(91, "DATE", Date.class), new JavaSqlType<Time>(92, "TIME", Time.class), new JavaSqlType<Timestamp>(93, "TIMESTAMP", Timestamp.class), new JavaSqlType<Clob>(2005, "CLOB", Clob.class), new JavaSqlType<Blob>(2004, "BLOB", Blob.class), new JavaSqlType<Array>(2003, "ARRAY", Array.class), new JavaSqlType<Ref>(2006, "REF", Ref.class), new JavaSqlType<Object>(2001, "DISTINCT", Object.class), new JavaSqlType<Object>(2002, "STRUCT", Object.class), new JavaSqlType<Object>(1111, "OTHER", Object.class), new JavaSqlType<Object>(2000, "JAVA_OBJECT", Object.class), new JavaSqlType<URL>(70, "DATALINK", URL.class), new JavaSqlType<Boolean>(-7, "BIT", Boolean.TYPE), new JavaSqlType<Boolean>(16, "BOOLEAN", Boolean.TYPE), new JavaSqlType<String>(100, "VARCHAR_IGNORECASE", String.class)};
    private static HashMap<Integer, JavaSqlType<?>> javaSqlTypeMap = null;
    private static HashMap<String, JavaSqlType<?>> javaSqlTypeNameMap = null;

    private JavaSqlTypes() {
    }

    public static JavaSqlType<?> getJavaSqlType(int javaSqlType) {
        JavaSqlType<?> jdbcType = JavaSqlTypes.getJdbcTypeMap().get(javaSqlType);
        if (jdbcType == null) {
            return JavaSqlTypes.getJdbcTypeMap().get(12);
        }
        return jdbcType;
    }

    public static int getJavaSqlType(String javaSqlTypeName) {
        JavaSqlType<?> jdbcType = JavaSqlTypes.getJdbcTypeNameMap().get(javaSqlTypeName);
        if (jdbcType == null) {
            return 12;
        }
        return jdbcType.getJavaSqlType();
    }

    public static Class<?> getSqlTypeClass(int javaSqlType) {
        return JavaSqlTypes.getSqlTypeClass(new Integer(javaSqlType));
    }

    public static Class<?> getSqlTypeClass(Integer javaSqlType) {
        JavaSqlType<?> jdbcType = JavaSqlTypes.getJdbcTypeMap().get(javaSqlType);
        if (jdbcType == null) {
            jdbcType = JavaSqlTypes.getJdbcTypeMap().get(12);
        }
        return jdbcType.getJavaClass();
    }

    public static Class<?> getSqlTypeClass(String javaSqlTypeName) {
        JavaSqlType<?> jdbcType = JavaSqlTypes.getJdbcTypeNameMap().get(javaSqlTypeName);
        if (jdbcType == null) {
            jdbcType = JavaSqlTypes.getJdbcTypeMap().get(12);
        }
        return jdbcType.getJavaClass();
    }

    public static Collection<String> getSqlTypes() {
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(JavaSqlTypes.getJdbcTypeNameMap().keySet());
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMaps() {
        JavaSqlType<?>[] javaSqlTypeArray = jdbcTypes;
        synchronized (jdbcTypes) {
            if (javaSqlTypeMap == null) {
                javaSqlTypeMap = new HashMap();
                javaSqlTypeNameMap = new HashMap();
                for (JavaSqlType<?> jst : jdbcTypes) {
                    javaSqlTypeMap.put(new Integer(jst.getJavaSqlType()), jst);
                    javaSqlTypeNameMap.put(jst.getJavaSqlTypeName(), jst);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HashMap<Integer, JavaSqlType<?>> getJdbcTypeMap() {
        if (javaSqlTypeMap == null) {
            JavaSqlTypes.initMaps();
        }
        return javaSqlTypeMap;
    }

    private static HashMap<String, JavaSqlType<?>> getJdbcTypeNameMap() {
        if (javaSqlTypeNameMap == null) {
            JavaSqlTypes.initMaps();
        }
        return javaSqlTypeNameMap;
    }
}

