/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoOrderBy;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;
import org.synchronoss.cpo.jdbc.JdbcParameter;
import org.synchronoss.cpo.jdbc.JdbcQuery;
import org.synchronoss.cpo.jdbc.JdbcWhereBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPreparedStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)JdbcPreparedStatementFactory.class.getName());
    private Logger localLogger = null;
    private PreparedStatement ps_ = null;
    private ArrayList<CpoReleasible> releasibles = new ArrayList();
    private JdbcQuery jq_ = null;
    private Collection<BindAttribute> bindValues_ = null;
    private static final String WHERE_MARKER = "__CPO_WHERE__";
    private static final String ORDERBY_MARKER = "__CPO_ORDERBY__";

    private JdbcPreparedStatementFactory() {
    }

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, JdbcMetaClass<T> jmcCriteria, JdbcQuery jq, T obj) throws CpoException {
        this(conn, jca, jmcCriteria, jq, obj, null, null, null);
    }

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, JdbcMetaClass<T> jmcCriteria, JdbcQuery jq, T obj, CpoWhere where, Collection<CpoOrderBy> orderBy) throws CpoException {
        this(conn, jca, jmcCriteria, jq, obj, where, orderBy, null);
    }

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, JdbcMetaClass<T> jmcCriteria, JdbcQuery jq, T obj, CpoWhere where, Collection<CpoOrderBy> orderBy, Collection<BindAttribute> bindValues) throws CpoException {
        String sql = this.buildSql(jmcCriteria, jq.getText(), where, orderBy, bindValues);
        this.localLogger = obj == null ? logger : Logger.getLogger((String)obj.getClass().getName());
        this.localLogger.info((Object)("JdbcQuery SQL = <" + sql + ">"));
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.localLogger.error((Object)("Error Instantiating JdbcPreparedStatementFactory SQL=<" + sql + ">" + se.getLocalizedMessage()));
            throw new CpoException(se);
        }
        this.setPreparedStatement(pstmt);
        this.setJdbcQuery(jq);
        this.setBindValues(bindValues);
        this.bindParameters(obj);
    }

    private <T> String buildSql(JdbcMetaClass<T> jmc, String sql, CpoWhere where, Collection<CpoOrderBy> orderBy, Collection<BindAttribute> bindValues) throws CpoException {
        StringBuffer sqlText = new StringBuffer();
        Iterator<CpoOrderBy> obIt = null;
        JdbcCpoOrderBy ob = null;
        JdbcWhereBuilder<T> jwb = new JdbcWhereBuilder<T>(jmc);
        JdbcCpoWhere jcw = (JdbcCpoWhere)where;
        sqlText.append(sql);
        if (jcw != null) {
            try {
                jcw.acceptDFVisitor(jwb);
            }
            catch (Exception e) {
                throw new CpoException("Unable to build WHERE clause", e);
            }
            if (sqlText.indexOf(WHERE_MARKER) == -1) {
                sqlText.append(jwb.getWhereClause());
            } else {
                sqlText = this.replaceMarker(sqlText, WHERE_MARKER, jwb.getWhereClause());
            }
            bindValues.addAll(jwb.getBindValues());
        } else {
            sqlText = this.replaceMarker(sqlText, WHERE_MARKER, "");
        }
        if (orderBy != null) {
            StringBuffer obBuff = new StringBuffer();
            obIt = orderBy.iterator();
            try {
                if (obIt.hasNext()) {
                    obBuff.append(" ORDER BY ");
                    ob = (JdbcCpoOrderBy)obIt.next();
                    obBuff.append(ob.toString(jmc));
                }
                while (obIt.hasNext()) {
                    obBuff.append(", ");
                    ob = (JdbcCpoOrderBy)obIt.next();
                    obBuff.append(ob.toString(jmc));
                }
            }
            catch (CpoException ce) {
                throw new CpoException("Error Processing OrderBy Attribute<" + ce.getLocalizedMessage() + "> not Found. JDBC Query=<" + sqlText.toString() + obBuff.toString() + ">");
            }
            if (sqlText.indexOf(ORDERBY_MARKER) == -1) {
                sqlText.append(obBuff);
            } else {
                sqlText = this.replaceMarker(sqlText, ORDERBY_MARKER, obBuff.toString());
            }
        } else {
            sqlText = this.replaceMarker(sqlText, ORDERBY_MARKER, "");
        }
        return sqlText.toString();
    }

    protected StringBuffer replaceMarker(StringBuffer source, String marker, String replace) {
        int attrOffset = 0;
        int fromIndex = 0;
        int mLength = marker.length();
        int rLength = replace.length();
        if (source != null && source.length() > 0) {
            while ((attrOffset = source.indexOf(marker, fromIndex)) != -1) {
                source.replace(attrOffset, attrOffset + mLength, replace);
                fromIndex = attrOffset + rLength;
            }
        }
        return source;
    }

    public PreparedStatement getPreparedStatement() {
        return this.ps_;
    }

    protected void setPreparedStatement(PreparedStatement ps) {
        this.ps_ = ps;
    }

    public void AddReleasible(CpoReleasible releasible) {
        if (releasible != null) {
            this.releasibles.add(releasible);
        }
    }

    @Override
    public void release() throws CpoException {
        for (CpoReleasible releasible : this.releasibles) {
            try {
                releasible.release();
            }
            catch (CpoException ce) {
                this.localLogger.error((Object)"Error Releasing Prepared Statement Transform Object", (Throwable)ce);
                throw ce;
            }
        }
    }

    public void bindParameters(Object obj) throws CpoException {
        int j = 0;
        ArrayList<JdbcParameter> parameters = this.getJdbcQuery().getParameterList();
        JdbcParameter parameter = null;
        JdbcAttribute attribute = null;
        int preparedStatementArgNum = 0;
        Collection<BindAttribute> bindValues = this.getBindValues();
        for (j = 0; j < parameters.size(); ++j) {
            ++preparedStatementArgNum;
            parameter = parameters.get(j);
            if (parameter == null) {
                throw new CpoException("JdbcParameter is null!");
            }
            attribute = parameter.getAttribute();
            attribute.invokeGetter(this, obj, preparedStatementArgNum);
        }
        ++j;
        if (bindValues != null) {
            for (BindAttribute bindAttr : bindValues) {
                Object bindObject = bindAttr.getBindObject();
                JdbcAttribute ja = bindAttr.getJdbcAttribute();
                JavaSqlMethod<?> jsm = JavaSqlMethods.getJavaSqlMethod(bindObject.getClass());
                if (jsm != null) {
                    try {
                        if (ja == null) {
                            this.localLogger.debug((Object)(bindAttr.getName() + "=" + bindObject));
                        } else {
                            this.localLogger.debug((Object)(ja.getDbName() + "=" + bindObject));
                        }
                        jsm.getPsSetter().invoke((Object)this.getPreparedStatement(), new Integer(j++), bindObject);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        this.localLogger.error((Object)("Error Accessing Prepared Statement Setter: " + iae.getLocalizedMessage()));
                        throw new CpoException(iae);
                    }
                    catch (InvocationTargetException ite) {
                        this.localLogger.error((Object)("Error Invoking Prepared Statement Setter: " + ite.getCause().getLocalizedMessage()));
                        throw new CpoException(ite.getCause());
                    }
                }
                ja.invokeGetter(this, bindObject, j++);
            }
        }
    }

    protected Collection<BindAttribute> getBindValues() {
        return this.bindValues_;
    }

    protected void setBindValues(Collection<BindAttribute> bindValues_) {
        this.bindValues_ = bindValues_;
    }

    protected JdbcQuery getJdbcQuery() {
        return this.jq_;
    }

    protected void setJdbcQuery(JdbcQuery jq_) {
        this.jq_ = jq_;
    }
}

