/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.encrypt;

import org.apache.log4j.Logger;
import org.synchronoss.cpo.encrypt.Encryptor;

public class EncryptorFactory {
    private static String defaultEncryptor = "org.synchronoss.gateway.cpo.jdbc.GatewayEncryptor";
    private static Logger logger = Logger.getLogger((String)EncryptorFactory.class.getName());

    public static Encryptor getEncryptor(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.debug((Object)("Entering getEncryptor(" + className + ")"));
        Encryptor enc = null;
        Class<?> c = Class.forName(className);
        Object o = c.newInstance();
        enc = (Encryptor)o;
        logger.debug((Object)("Created encryptor with class " + enc.getClass()));
        return enc;
    }

    public static Encryptor getEncryptor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.debug((Object)"Entering getEncryptor()");
        Encryptor enc = null;
        String encryptorName = System.getProperty("synchronoss.defaultEncryptor");
        enc = encryptorName != null && !encryptorName.trim().equals("") ? EncryptorFactory.getEncryptor(encryptorName) : EncryptorFactory.getEncryptor(defaultEncryptor);
        return enc;
    }
}

