/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.ClientContext;
import tachyon.resource.ResourcePool;
import tachyon.thrift.NetAddress;
import tachyon.worker.WorkerClient;

public final class BlockWorkerClientPool
extends ResourcePool<WorkerClient> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final NetAddress mWorkerNetAddress;

    public BlockWorkerClientPool(NetAddress workerAddress) {
        super(ClientContext.getConf().getInt("tachyon.user.block.worker.client.threads"));
        this.mWorkerNetAddress = workerAddress;
    }

    @Override
    public void close() {
    }

    @Override
    public void release(WorkerClient workerClient) {
        try {
            workerClient.sessionHeartbeat();
        }
        catch (IOException ioe) {
            LOG.warn("Failed sending client metrics before releasing the worker client", (Throwable)ioe);
        }
        workerClient.createNewSession(ClientContext.getRandomNonNegativeLong());
        super.release(workerClient);
    }

    @Override
    protected WorkerClient createNewResource() {
        long clientId = ClientContext.getRandomNonNegativeLong();
        return new WorkerClient(this.mWorkerNetAddress, ClientContext.getExecutorService(), ClientContext.getConf(), clientId, true, ClientContext.getClientMetrics());
    }
}

