/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.oceanbase;

import java.util.Arrays;
import java.util.List;

class OceanBaseJdbcUtils {
    static final String MYSQL_JDBC_DRIVER = "com.mysql.cj.jdbc.Driver";
    static final String MYSQL_LEGACY_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    static final String OCEANBASE_JDBC_DRIVER = "com.oceanbase.jdbc.Driver";
    static final String OCEANBASE_LEGACY_JDBC_DRIVER = "com.alipay.oceanbase.jdbc.Driver";
    static final List<String> SUPPORTED_DRIVERS = Arrays.asList("com.oceanbase.jdbc.Driver", "com.alipay.oceanbase.jdbc.Driver", "com.mysql.cj.jdbc.Driver", "com.mysql.jdbc.Driver");

    OceanBaseJdbcUtils() {
    }

    static String getDriverClass() {
        for (String driverClass : SUPPORTED_DRIVERS) {
            try {
                Class.forName(driverClass);
                return driverClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("Can't find valid driver class for OceanBase");
    }

    static boolean isMySQLDriver(String driverClassName) {
        return MYSQL_JDBC_DRIVER.equals(driverClassName) || MYSQL_LEGACY_JDBC_DRIVER.equals(driverClassName);
    }

    static boolean isOceanBaseDriver(String driverClassName) {
        return OCEANBASE_JDBC_DRIVER.equals(driverClassName) || OCEANBASE_LEGACY_JDBC_DRIVER.equals(driverClassName);
    }
}

