/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;

public class TimeType
extends DataType {
    public static final TimeType TIME = new TimeType(MySQLType.TypeDuration);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeDuration};
    protected static final long NANOSECOND = 1L;
    protected static final long MICROSECOND = 1000L;
    protected static final long MILLISECOND = 1000000L;
    protected static final long SECOND = 1000000000L;
    protected static final long MINUTE = 60000000000L;
    protected static final long HOUR = 3600000000000L;

    protected TimeType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    protected TimeType(MySQLType type, int flag, int len, int decimal) {
        super(type, flag, len, decimal, "", 83);
    }

    protected TimeType(MySQLType tp) {
        super(tp);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        if (flag == 8) {
            return Codec.IntegerCodec.readVarLong(cdi);
        }
        if (flag == 7) {
            return Codec.IntegerCodec.readLong(cdi);
        }
        throw new TypeException("Invalid TimeType flag: " + flag);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        Codec.IntegerCodec.writeDuration(cdo, Converter.convertToLong(value));
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        this.encodeKey(cdo, value);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        if (value instanceof Long) {
            Codec.IntegerCodec.writeLong(cdo, (Long)value);
        } else {
            long val = Converter.convertStrToDuration(Converter.convertToString(value));
            Codec.IntegerCodec.writeLong(cdo, val);
        }
    }

    @Override
    public String getName() {
        return "TIME";
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlDuration;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return Converter.convertStrToDuration(value);
    }
}

