/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl;

import junit.framework.TestCase;
import org.tinygroup.tinysqldsl.ComplexSelect;
import org.tinygroup.tinysqldsl.CustomTable;
import org.tinygroup.tinysqldsl.ScoreTable;
import org.tinygroup.tinysqldsl.Select;
import org.tinygroup.tinysqldsl.base.Condition;
import org.tinygroup.tinysqldsl.base.FragmentSql;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.extend.MysqlSelect;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.select.Join;
import org.tinygroup.tinysqldsl.select.OrderByElement;
import org.tinygroup.tinysqldsl.selectitem.SelectItem;
import org.tinygroup.tinysqldsl.selectitem.Top;

public class JunitTestSelect
extends TestCase {
    public void testSelect() {
        JunitTestSelect.assertEquals((String)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).sql(), (String)"SELECT * FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{Select.customSelectItem((String)"%s,%s", (SelectItem[])new SelectItem[]{CustomTable.CUSTOM.NAME, CustomTable.CUSTOM.AGE})}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT custom.name,custom.age FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{Select.customSelectItem((String)"upper(%s),%s", (SelectItem[])new SelectItem[]{CustomTable.CUSTOM.NAME, CustomTable.CUSTOM.AGE})}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT upper(custom.name),custom.age FROM custom");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).orderBy(new OrderByElement[]{OrderByElement.desc((Expression)CustomTable.CUSTOM.NAME)})).sql(), (String)"SELECT * FROM custom ORDER BY custom.name DESC");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).orderBy(new OrderByElement[]{OrderByElement.asc((Expression)CustomTable.CUSTOM.ID)})).sql(), (String)"SELECT * FROM custom ORDER BY custom.id");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.eq((Object)"abc"))).sql(), (String)"SELECT * FROM custom WHERE custom.name = ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.like("abc"))).sql(), (String)"SELECT * FROM custom WHERE custom.name LIKE ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(StatementSqlBuilder.or((Condition[])new Condition[]{CustomTable.CUSTOM.NAME.like("abc"), CustomTable.CUSTOM.AGE.gt((Object)20)}))).sql(), (String)"SELECT * FROM custom WHERE custom.name LIKE ? or custom.age > ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(StatementSqlBuilder.and((Condition[])new Condition[]{CustomTable.CUSTOM.NAME.like("abc"), CustomTable.CUSTOM.AGE.gt((Object)20)}))).sql(), (String)"SELECT * FROM custom WHERE custom.name LIKE ? and custom.age > ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.leftLike("abc"))).sql(), (String)"SELECT * FROM custom WHERE custom.name LIKE ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.rightLike("abc"))).sql(), (String)"SELECT * FROM custom WHERE custom.name LIKE ?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.isNull())).sql(), (String)"SELECT * FROM custom WHERE custom.name IS NULL");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.isNotNull())).sql(), (String)"SELECT * FROM custom WHERE custom.name IS NOT NULL");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.AGE.between((Object)23, (Object)25))).sql(), (String)"SELECT * FROM custom WHERE custom.age BETWEEN ? AND ?");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE.max()}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT max(custom.age) FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE.min()}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT min(custom.age) FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE.avg()}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT avg(custom.age) FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE.count()}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT count(custom.age) FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE.sum()}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT sum(custom.age) FROM custom");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.NAME.distinct()}).from((FromItem)CustomTable.CUSTOM).forUpdate().sql(), (String)"SELECT DISTINCT (custom.name)  FROM custom FOR UPDATE");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.NAME, CustomTable.CUSTOM.AGE, ScoreTable.TSCORE.SCORE}).from((FromItem)CustomTable.CUSTOM).join(new Join[]{Join.leftJoin((FromItem)ScoreTable.TSCORE, (Expression)CustomTable.CUSTOM.NAME.eq((Object)ScoreTable.TSCORE.NAME))}).sql(), (String)"SELECT custom.name,custom.age,score.score FROM custom LEFT JOIN score ON custom.name = score.name");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{FragmentSql.fragmentSelect((String)"custom.name,custom.age")}).from((FromItem)FragmentSql.fragmentFrom((String)"custom custom")).where(FragmentSql.fragmentCondition((String)"custom.name=?", (Object[])new Object[]{"\u60a0\u60a0\u7136\u7136"})).sql(), (String)"SELECT custom.name,custom.age FROM custom custom WHERE custom.name=?");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.ID.count()}).from((FromItem)CustomTable.CUSTOM).groupBy(new Expression[]{CustomTable.CUSTOM.AGE}).sql(), (String)"SELECT count(custom.id) FROM custom GROUP BY custom.age");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.ID.count()}).from((FromItem)CustomTable.CUSTOM).groupBy(new Expression[]{CustomTable.CUSTOM.NAME, CustomTable.CUSTOM.AGE}).sql(), (String)"SELECT count(custom.id) FROM custom GROUP BY custom.name,custom.age");
        JunitTestSelect.assertEquals((String)ComplexSelect.union((Select[])new Select[]{MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}), MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM})}).sql(), (String)"(SELECT * FROM custom) UNION (SELECT * FROM custom)");
        JunitTestSelect.assertEquals((String)ComplexSelect.unionAll((Select[])new Select[]{MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}), MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM})}).sql(), (String)"(SELECT * FROM custom) UNION ALL (SELECT * FROM custom)");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE, CustomTable.CUSTOM.NAME}).from((FromItem)CustomTable.CUSTOM).join(new Join[]{Join.rightJoin((FromItem)ScoreTable.TSCORE, (Expression)ScoreTable.TSCORE.NAME.eq((Object)CustomTable.CUSTOM.NAME))}).sql(), (String)"SELECT custom.age,custom.name FROM custom RIGHT JOIN score ON score.name = custom.name");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.AGE, CustomTable.CUSTOM.NAME}).from((FromItem)CustomTable.CUSTOM).join(new Join[]{Join.fullJoin((FromItem)ScoreTable.TSCORE, (Expression)ScoreTable.TSCORE.NAME.eq((Object)CustomTable.CUSTOM.NAME))}).sql(), (String)"SELECT custom.age,custom.name FROM custom FULL JOIN score ON score.name = custom.name");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{ScoreTable.TSCORE.SCORE.sum()}).from((FromItem)ScoreTable.TSCORE).groupBy(new Expression[]{ScoreTable.TSCORE.NAME}).having(ScoreTable.TSCORE.SCORE.sum().gt((Object)300)).sql(), (String)"SELECT sum(score.score) FROM score GROUP BY score.name HAVING sum(score.score) > ?");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{Top.top((long)10L), CustomTable.CUSTOM.NAME}).from((FromItem)CustomTable.CUSTOM).sql(), (String)"SELECT TOP (10),custom.name FROM custom");
        JunitTestSelect.assertEquals((String)((MysqlSelect)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.AGE.gt((Object)30))).forUpdate()).sql(), (String)"SELECT * FROM custom WHERE custom.age > ? FOR UPDATE");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{ScoreTable.TSCORE.SCORE.avg(), ScoreTable.TSCORE.NAME}).from((FromItem)ScoreTable.TSCORE).groupBy(new Expression[]{ScoreTable.TSCORE.NAME}).sql(), (String)"SELECT avg(score.score),score.name FROM score GROUP BY score.name");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{ScoreTable.TSCORE.SCORE.sum(), ScoreTable.TSCORE.NAME}).from((FromItem)ScoreTable.TSCORE).having(ScoreTable.TSCORE.SCORE.sum().gt((Object)200)).orderBy(new OrderByElement[]{OrderByElement.asc((Expression)ScoreTable.TSCORE.SCORE.sum())}).sql(), (String)"SELECT sum(score.score),score.name FROM score HAVING sum(score.score) > ? ORDER BY sum(score.score)");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{FragmentSql.fragmentSelect((String)"sum(score.score) s"), ScoreTable.TSCORE.NAME}).from((FromItem)ScoreTable.TSCORE).having(FragmentSql.fragmentCondition((String)"s>?", (Object[])new Object[]{"200"})).orderBy(new OrderByElement[]{OrderByElement.asc((Expression)FragmentSql.fragmentCondition((String)"s", (Object[])new Object[0]))}).sql(), (String)"SELECT sum(score.score) s,score.name FROM score HAVING s>? ORDER BY s");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{CustomTable.CUSTOM.NAME, ScoreTable.TSCORE.SCORE}).from((FromItem)CustomTable.CUSTOM).join(new Join[]{Join.newJoin((FromItem)ScoreTable.TSCORE, (Expression)CustomTable.CUSTOM.NAME.eq((Object)ScoreTable.TSCORE.NAME))}).sql(), (String)"SELECT custom.name,score.score FROM custom JOIN score ON custom.name = score.name");
        JunitTestSelect.assertEquals((String)Select.select((SelectItem[])new SelectItem[]{FragmentSql.fragmentSelect((String)"r"), CustomTable.CUSTOM.NAME, CustomTable.CUSTOM.AGE}).from((FromItem)FragmentSql.fragmentFrom((String)"(select ROWNUM r,custom.name,custom.age from custom where r>=1)")).where(FragmentSql.fragmentCondition((String)"r<=?", (Object[])new Object[]{10})).sql(), (String)"SELECT r,custom.name,custom.age FROM (select ROWNUM r,custom.name,custom.age from custom where r>=1) WHERE r<=?");
        JunitTestSelect.assertEquals((String)((MysqlSelect)MysqlSelect.selectFrom((Table[])new Table[]{CustomTable.CUSTOM}).where(CustomTable.CUSTOM.NAME.eq((Object)"abc").and(CustomTable.CUSTOM.AGE.greaterThan((Object)30)).or(CustomTable.CUSTOM.ID.in(new Object[]{1, 3, 6})))).sql(), (String)"SELECT * FROM custom WHERE custom.name = ? AND custom.age > ? OR custom.id IN (?, ?, ?)");
    }
}

