/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.base;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.tinysqldsl.base.Alias;
import org.tinygroup.tinysqldsl.base.MultiPartName;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.base.Value;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.FragmentExpressionSql;
import org.tinygroup.tinysqldsl.operator.ColumnOperator;
import org.tinygroup.tinysqldsl.selectitem.Distinct;
import org.tinygroup.tinysqldsl.selectitem.SelectItem;

public class Column
extends ColumnOperator
implements Expression,
MultiPartName,
SelectItem,
Cloneable {
    private Table table;
    private String columnName;
    private Alias alias;

    public Column() {
    }

    public Column(Table table, String columnName) {
        this.table = table;
        this.columnName = columnName;
    }

    public Column as(String aliasName) {
        return this.as(aliasName, false);
    }

    public Column as(String aliasName, boolean withAs) {
        try {
            Column column = (Column)this.clone();
            column.setAlias(new Alias(aliasName, withAs));
            return column;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Column(Table table, String columnName, String alias) {
        this(table, columnName);
        this.alias = new Alias(alias);
    }

    public Column(String columnName) {
        this(null, columnName);
    }

    public Distinct distinct() {
        return new Distinct(this);
    }

    public Value value(Object value) {
        return new Value(this, value);
    }

    public Value value(Expression expression) {
        return new Value(this, expression);
    }

    public Value fragmentValue(String fragmentSql) {
        return new Value(this, new FragmentExpressionSql(fragmentSql));
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        if (this.table != null) {
            fqn.append(this.table.getReferenceName());
        }
        if (fqn.length() > 0) {
            fqn.append('.');
        }
        if (this.columnName != null) {
            fqn.append(this.columnName);
        }
        return fqn.toString();
    }

    public String toString() {
        return this.getFullyQualifiedName() + (this.alias != null ? this.alias.toString() : "");
    }

    public void builderExpression(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
    }

    private void internalBuilder(StatementSqlBuilder builder) {
        String tableName = this.getTableName();
        String result = "";
        if (!StringUtil.isBlank((String)tableName)) {
            result = result + tableName + ".";
        }
        result = result + this.columnName;
        builder.appendSql(result);
    }

    private String getTableName() {
        String tableName = null;
        if (this.table != null) {
            tableName = this.table.getAlias() != null ? this.table.getAlias().getName() : this.table.getFullyQualifiedName();
        }
        return tableName;
    }

    public void builderSelectItem(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
        if (this.alias != null) {
            builder.appendSql(this.alias.toString());
        }
    }
}

