/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.base.Condition;
import org.tinygroup.tinysqldsl.base.StatementBody;
import org.tinygroup.tinysqldsl.expression.BinaryExpression;
import org.tinygroup.tinysqldsl.expression.conditional.ConditionExpressionList;
import org.tinygroup.tinysqldsl.expression.relational.OldOracleJoinBinaryExpression;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.select.Fetch;
import org.tinygroup.tinysqldsl.select.Join;
import org.tinygroup.tinysqldsl.select.Limit;
import org.tinygroup.tinysqldsl.select.Offset;
import org.tinygroup.tinysqldsl.select.OrderByElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementSqlBuilder {
    private List<Object> values;
    protected StringBuilder stringBuilder;
    private transient boolean hasBuild;
    private boolean useBracketsInExprList = true;

    public StatementSqlBuilder() {
        this(new StringBuilder(), new ArrayList<Object>());
    }

    public StatementSqlBuilder(StringBuilder stringBuilder, List<Object> values) {
        this.values = values;
        this.stringBuilder = stringBuilder;
    }

    public void build(StatementBody statementBody) {
        statementBody.builderStatement(this);
    }

    public void appendSql(String segment) {
        this.stringBuilder.append(segment);
    }

    public void addParamValue(Object ... values) {
        Collections.addAll(this.values, values);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public String sql() {
        if (this.hasBuild) {
            return this.stringBuilder.toString();
        }
        this.parserStatementBody();
        this.hasBuild = true;
        return this.stringBuilder.toString();
    }

    protected abstract void parserStatementBody();

    public static Condition and(Condition ... conditions) {
        return StatementSqlBuilder.conditional(" and ", conditions);
    }

    private static Condition conditional(String comma, Condition ... conditions) {
        Assert.assertNotNull((Object)conditions, (String)"conditions must not null", (Object[])new Object[0]);
        Assert.assertTrue((conditions.length >= 2 ? 1 : 0) != 0, (String)"conditions \u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e2", (Object[])new Object[0]);
        ConditionExpressionList expressionList = new ConditionExpressionList();
        expressionList.setComma(comma);
        expressionList.setUseBrackets(false);
        ArrayList values = new ArrayList();
        for (Condition condition : conditions) {
            if (condition == null) continue;
            expressionList.addExpression(condition.getExpression());
            Collections.addAll(values, condition.getValues());
        }
        if (expressionList.getExpressions().isEmpty()) {
            return null;
        }
        return new Condition(expressionList, values.toArray());
    }

    public static Condition or(Condition ... conditions) {
        return StatementSqlBuilder.conditional(" or ", conditions);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        if (binaryExpression.isNot()) {
            this.stringBuilder.append(" NOT ");
        }
        binaryExpression.getLeftExpression().builderExpression(this);
        this.stringBuilder.append(operator);
        binaryExpression.getRightExpression().builderExpression(this);
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        if (expression.isNot()) {
            this.stringBuilder.append(" NOT ");
        }
        expression.getLeftExpression().builderExpression(this);
        if (expression.getOldOracleJoinSyntax() == 1) {
            this.stringBuilder.append("(+)");
        }
        this.stringBuilder.append(operator);
        expression.getRightExpression().builderExpression(this);
        if (expression.getOldOracleJoinSyntax() == 2) {
            this.stringBuilder.append("(+)");
        }
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.stringBuilder.append(",");
        } else {
            if (join.isRight()) {
                this.stringBuilder.append(" RIGHT");
            } else if (join.isNatural()) {
                this.stringBuilder.append(" NATURAL");
            } else if (join.isFull()) {
                this.stringBuilder.append(" FULL");
            } else if (join.isLeft()) {
                this.stringBuilder.append(" LEFT");
            } else if (join.isCross()) {
                this.stringBuilder.append(" CROSS");
            }
            if (join.isOuter()) {
                this.stringBuilder.append(" OUTER");
            }
            this.stringBuilder.append(" JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.builderFromItem(this);
        if (join.getOnExpression() != null) {
            this.stringBuilder.append(" ON ");
            join.getOnExpression().builderExpression(this);
        }
        if (join.getUsingColumns() != null) {
            this.stringBuilder.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.stringBuilder.append(column.getFullyQualifiedName());
                if (!iterator.hasNext()) continue;
                this.stringBuilder.append(",");
            }
            this.stringBuilder.append(")");
        }
    }

    public void deparseOrderBy(List<OrderByElement> orderByElements) {
        this.deparseOrderBy(false, orderByElements);
    }

    public void deparseOrderBy(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        if (oracleSiblings) {
            this.stringBuilder.append(" ORDER SIBLINGS BY ");
        } else {
            this.stringBuilder.append(" ORDER BY ");
        }
        Iterator<OrderByElement> iter = orderByElements.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = iter.next();
            this.appendSql(orderByElement.toString());
            if (!iter.hasNext()) continue;
            this.stringBuilder.append(",");
        }
    }

    public void deparseLimit(Limit limit) {
        if (limit.isRowCountJdbcParameter()) {
            this.stringBuilder.append(" LIMIT ");
            this.stringBuilder.append("?");
            this.values.add(limit.getRowCount());
        } else if (limit.getRowCount() >= 0L) {
            this.stringBuilder.append(" LIMIT ");
            this.stringBuilder.append(limit.getRowCount());
        } else if (limit.isLimitNull()) {
            this.stringBuilder.append(" LIMIT NULL");
        }
        if (limit.isOffsetJdbcParameter()) {
            this.stringBuilder.append(" OFFSET ?");
            this.values.add(limit.getOffset());
        } else if (limit.getOffset() != 0L) {
            this.stringBuilder.append(" OFFSET ").append(limit.getOffset());
        }
    }

    public void deparseOffset(Offset offset) {
        if (offset.getOffset() >= 0L) {
            if (offset.isOffsetJdbcParameter()) {
                this.stringBuilder.append(" OFFSET ?");
                this.values.add(offset.getOffset());
            } else {
                this.stringBuilder.append(" OFFSET ");
                this.stringBuilder.append(offset.getOffset());
            }
            if (offset.getOffsetParam() != null) {
                this.stringBuilder.append(" ").append(offset.getOffsetParam());
            }
        }
    }

    public void deparseFetch(Fetch fetch) {
        this.stringBuilder.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.stringBuilder.append("FIRST ");
        } else {
            this.stringBuilder.append("NEXT ");
        }
        if (fetch.isFetchJdbcParameter()) {
            this.stringBuilder.append("?");
            this.values.add(fetch.getRowCount());
        } else {
            this.stringBuilder.append(fetch.getRowCount());
        }
        this.stringBuilder.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public boolean isUseBracketsInExprList() {
        return this.useBracketsInExprList;
    }

    public void setUseBracketsInExprList(boolean useBracketsInExprList) {
        this.useBracketsInExprList = useBracketsInExprList;
    }
}

