/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression;

import java.util.List;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseExpression
implements Expression {
    private Expression switchExpression;
    private List<Expression> whenClauses;
    private Expression elseExpression;

    public Expression getSwitchExpression() {
        return this.switchExpression;
    }

    public void setSwitchExpression(Expression switchExpression) {
        this.switchExpression = switchExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    public void setElseExpression(Expression elseExpression) {
        this.elseExpression = elseExpression;
    }

    public List<Expression> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<Expression> whenClauses) {
        this.whenClauses = whenClauses;
    }

    public String toString() {
        return "CASE " + (this.switchExpression != null ? this.switchExpression + " " : "") + DslUtil.getStringList(this.whenClauses, false, false) + " " + (this.elseExpression != null ? "ELSE " + this.elseExpression + " " : "") + "END";
    }

    @Override
    public void builderExpression(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append("CASE ");
        Expression switchExp = this.getSwitchExpression();
        if (switchExp != null) {
            switchExp.builderExpression(builder);
            buffer.append(" ");
        }
        for (Expression exp : this.getWhenClauses()) {
            exp.builderExpression(builder);
        }
        Expression elseExp = this.getElseExpression();
        if (elseExp != null) {
            buffer.append("ELSE ");
            elseExp.builderExpression(builder);
            buffer.append(" ");
        }
        buffer.append("END");
    }
}

