/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.relational;

import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;

public class Between
implements Expression {
    private Expression leftExpression;
    private boolean not = false;
    private Expression betweenExpressionStart;
    private Expression betweenExpressionEnd;

    public Between(Expression leftExpression, Expression betweenExpressionStart, Expression betweenExpressionEnd) {
        this(leftExpression, betweenExpressionStart, betweenExpressionEnd, false);
    }

    public Between(Expression leftExpression, Expression betweenExpressionStart, Expression betweenExpressionEnd, boolean not) {
        this.leftExpression = leftExpression;
        this.betweenExpressionStart = betweenExpressionStart;
        this.betweenExpressionEnd = betweenExpressionEnd;
        this.not = not;
    }

    public Expression getBetweenExpressionEnd() {
        return this.betweenExpressionEnd;
    }

    public Expression getBetweenExpressionStart() {
        return this.betweenExpressionStart;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setBetweenExpressionEnd(Expression expression) {
        this.betweenExpressionEnd = expression;
    }

    public void setBetweenExpressionStart(Expression expression) {
        this.betweenExpressionStart = expression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public void setNot(boolean b) {
        this.not = b;
    }

    public String toString() {
        return this.leftExpression + " " + (this.not ? "NOT " : "") + "BETWEEN " + this.betweenExpressionStart + " AND " + this.betweenExpressionEnd;
    }

    public void builderExpression(StatementSqlBuilder builder) {
        this.getLeftExpression().builderExpression(builder);
        StringBuilder buffer = builder.getStringBuilder();
        if (this.isNot()) {
            buffer.append(" NOT");
        }
        buffer.append(" BETWEEN ");
        this.getBetweenExpressionStart().builderExpression(builder);
        buffer.append(" AND ");
        this.getBetweenExpressionEnd().builderExpression(builder);
    }
}

