/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.relational;

import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.BinaryExpression;
import org.tinygroup.tinysqldsl.expression.Expression;

public class LikeExpression
extends BinaryExpression {
    private String escape = null;

    public LikeExpression(Expression leftExpression, Expression rightExpression, boolean not) {
        super(leftExpression, rightExpression, not);
    }

    public LikeExpression(Expression leftExpression, Expression rightExpression) {
        super(leftExpression, rightExpression);
    }

    public String getStringExpression() {
        return (this.isNot() ? "NOT " : "") + "LIKE";
    }

    public String toString() {
        String retval = super.toString();
        if (this.escape != null) {
            retval = retval + " ESCAPE '" + this.escape + "'";
        }
        return retval;
    }

    public String getEscape() {
        return this.escape;
    }

    public void setEscape(String escape) {
        this.escape = escape;
    }

    public void builderExpression(StatementSqlBuilder builder) {
        builder.visitBinaryExpression(this, " LIKE ");
        StringBuilder buffer = builder.getStringBuilder();
        String escape = this.getEscape();
        if (escape != null) {
            buffer.append(" ESCAPE '").append(escape).append('\'');
        }
    }
}

