/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.select;

import java.util.List;
import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join {
    private boolean outer = false;
    private boolean right = false;
    private boolean left = false;
    private boolean natural = false;
    private boolean full = false;
    private boolean inner = false;
    private boolean simple = false;
    private boolean cross = false;
    private FromItem rightItem;
    private Expression onExpression;
    private List<Column> usingColumns;

    public Join(FromItem rightItem, Expression onExpression) {
        this.rightItem = rightItem;
        this.onExpression = onExpression;
    }

    public static Join simpleJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.simple = true;
        return join;
    }

    public static Join rightOutJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.outer = true;
        join.right = true;
        return join;
    }

    public static Join leftOutJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.outer = true;
        join.left = true;
        return join;
    }

    public static Join fullOutJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.outer = true;
        join.full = true;
        return join;
    }

    public static Join rightJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.inner = true;
        join.right = true;
        return join;
    }

    public static Join leftJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.inner = true;
        join.left = true;
        return join;
    }

    public static Join crossJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.inner = true;
        join.cross = true;
        return join;
    }

    public static Join fullJoin(FromItem rightItem, Expression onExpression) {
        Join join = Join.newJoin(rightItem, onExpression);
        join.inner = true;
        join.full = true;
        return join;
    }

    public static Join newJoin(FromItem rightItem, Expression onExpression) {
        Join join = new Join(rightItem, onExpression);
        return join;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean b) {
        this.simple = b;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setInner(boolean b) {
        this.inner = b;
    }

    public boolean isOuter() {
        return this.outer;
    }

    public void setOuter(boolean b) {
        this.outer = b;
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean b) {
        this.left = b;
    }

    public boolean isRight() {
        return this.right;
    }

    public void setRight(boolean b) {
        this.right = b;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean b) {
        this.natural = b;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setFull(boolean b) {
        this.full = b;
    }

    public boolean isCross() {
        return this.cross;
    }

    public void setCross(boolean cross) {
        this.cross = cross;
    }

    public FromItem getRightItem() {
        return this.rightItem;
    }

    public void setRightItem(FromItem item) {
        this.rightItem = item;
    }

    public Expression getOnExpression() {
        return this.onExpression;
    }

    public void setOnExpression(Expression expression) {
        this.onExpression = expression;
    }

    public List<Column> getUsingColumns() {
        return this.usingColumns;
    }

    public void setUsingColumns(List<Column> list) {
        this.usingColumns = list;
    }

    public String toString() {
        if (this.isSimple()) {
            return "" + this.rightItem;
        }
        String type = "";
        if (this.isRight()) {
            type = type + "RIGHT ";
        } else if (this.isNatural()) {
            type = type + "NATURAL ";
        } else if (this.isFull()) {
            type = type + "FULL ";
        } else if (this.isLeft()) {
            type = type + "LEFT ";
        } else if (this.isCross()) {
            type = type + "CROSS ";
        }
        if (this.isOuter()) {
            type = type + "OUTER ";
        }
        return type + "JOIN " + this.rightItem + (this.onExpression != null ? " ON " + this.onExpression + "" : "") + DslUtil.getFormattedList(this.usingColumns, "USING", true, true);
    }
}

