/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.OracleHierarchicalExpression;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.select.Fetch;
import org.tinygroup.tinysqldsl.select.Join;
import org.tinygroup.tinysqldsl.select.Limit;
import org.tinygroup.tinysqldsl.select.Offset;
import org.tinygroup.tinysqldsl.select.OrderByElement;
import org.tinygroup.tinysqldsl.selectitem.SelectItem;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainSelect
implements SelectBody {
    private List<SelectItem> selectItems = new ArrayList<SelectItem>();
    private List<Table> intoTables = new ArrayList<Table>();
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private List<Expression> groupByColumnReferences;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setIntoTables(List<Table> intoTables) {
        this.intoTables = intoTables;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public void addSelectItems(SelectItem ... items) {
        if (this.selectItems == null) {
            this.selectItems = new ArrayList<SelectItem>();
        }
        Collections.addAll(this.selectItems, items);
    }

    public void addIntoTables(Table ... tables) {
        if (this.intoTables == null) {
            this.intoTables = new ArrayList<Table>();
        }
        Collections.addAll(this.intoTables, tables);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public void addJoins(Join ... joinArray) {
        if (this.joins == null) {
            this.joins = new ArrayList<Join>();
        }
        Collections.addAll(this.joins, joinArray);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void addOrderByElements(OrderByElement ... orderBys) {
        if (this.orderByElements == null) {
            this.orderByElements = new ArrayList<OrderByElement>();
        }
        Collections.addAll(this.orderByElements, orderBys);
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public List<Expression> getGroupByColumnReferences() {
        return this.groupByColumnReferences;
    }

    public void setGroupByColumnReferences(List<Expression> list) {
        this.groupByColumnReferences = list;
    }

    public void addGroupByExpressions(Expression ... expressions) {
        if (this.groupByColumnReferences == null) {
            this.groupByColumnReferences = new ArrayList<Expression>();
        }
        Collections.addAll(this.groupByColumnReferences, expressions);
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(DslUtil.getStringList(this.selectItems));
        if (!CollectionUtil.isEmpty(this.intoTables)) {
            sql.append(" INTO ");
            Iterator<Table> iter = this.intoTables.iterator();
            while (iter.hasNext()) {
                sql.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sql.append(", ");
            }
        }
        if (this.fromItem != null) {
            sql.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        sql.append(", ").append(join);
                        continue;
                    }
                    sql.append(" ").append(join);
                }
            }
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                sql.append(this.oracleHierarchical.toString());
            }
            sql.append(DslUtil.getFormattedList(this.groupByColumnReferences, "GROUP BY"));
            if (this.having != null) {
                sql.append(" HAVING ").append(this.having);
            }
            sql.append(DslUtil.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.limit != null) {
                sql.append(this.limit);
            }
            if (this.offset != null) {
                sql.append(this.offset);
            }
            if (this.fetch != null) {
                sql.append(this.fetch);
            }
            if (this.isForUpdate()) {
                sql.append(" FOR UPDATE");
            }
        }
        return sql.toString();
    }

    @Override
    public void builderStatement(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append("SELECT ");
        Iterator<Object> iter = this.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = iter.next();
            selectItem.builderSelectItem(builder);
            if (!iter.hasNext()) continue;
            buffer.append(",");
        }
        if (!CollectionUtil.isEmpty(this.getIntoTables())) {
            buffer.append(" INTO ");
            iter = this.getIntoTables().iterator();
            while (iter.hasNext()) {
                ((Table)iter.next()).builderFromItem(builder);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
        }
        if (this.getFromItem() != null) {
            buffer.append(" FROM ");
            this.getFromItem().builderFromItem(builder);
        }
        if (this.getJoins() != null) {
            for (Join join : this.getJoins()) {
                builder.deparseJoin(join);
            }
        }
        if (this.getWhere() != null) {
            buffer.append(" WHERE ");
            this.getWhere().builderExpression(builder);
        }
        if (this.getOracleHierarchical() != null) {
            this.getOracleHierarchical().builderExpression(builder);
        }
        if (this.getGroupByColumnReferences() != null) {
            buffer.append(" GROUP BY ");
            iter = this.getGroupByColumnReferences().iterator();
            while (iter.hasNext()) {
                Expression columnReference = (Expression)iter.next();
                columnReference.builderExpression(builder);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
        }
        if (this.getHaving() != null) {
            buffer.append(" HAVING ");
            this.getHaving().builderExpression(builder);
        }
        if (this.getOrderByElements() != null) {
            builder.deparseOrderBy(this.isOracleSiblings(), this.getOrderByElements());
        }
        if (this.getLimit() != null) {
            builder.deparseLimit(this.getLimit());
        }
        if (this.getOffset() != null) {
            builder.deparseOffset(this.getOffset());
        }
        if (this.getFetch() != null) {
            builder.deparseFetch(this.getFetch());
        }
        if (this.isForUpdate()) {
            buffer.append(" FOR UPDATE");
        }
    }
}

