/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Set;
import org.umlg.java.metamodel.OJField;
import org.umlg.java.metamodel.OJForStatement;
import org.umlg.java.metamodel.OJIfStatement;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJSimpleStatement;
import org.umlg.java.metamodel.OJStatement;
import org.umlg.java.metamodel.generated.OJBlockGEN;
import org.umlg.java.metamodel.generated.OJForStatementGEN;
import org.umlg.java.metamodel.generated.OJIfStatementGEN;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJBlock
extends OJBlockGEN {
    public OJBlock() {
    }

    public OJBlock(String name, String comment) {
    }

    public void addToStatements(String name, String str) {
        if (str.length() == 0) {
            return;
        }
        OJSimpleStatement stat = new OJSimpleStatement();
        stat.setName(name);
        stat.setExpression(str);
        this.addToStatements(stat);
    }

    public void addToStatements(String str) {
        if (str.length() == 0) {
            return;
        }
        OJSimpleStatement stat = new OJSimpleStatement();
        stat.setExpression(str);
        this.addToStatements(stat);
    }

    public void addToStatements(int index, OJStatement statement) {
        this.getStatements().add(index, statement);
    }

    public void addToStatements(int indexOfRemoveVertex, String expression) {
        if (expression.length() == 0) {
            return;
        }
        OJSimpleStatement stat = new OJSimpleStatement();
        stat.setExpression(expression);
        this.addToStatements(indexOfRemoveVertex, stat);
    }

    @Override
    public String toJavaString() {
        String result = "";
        if (this.getComment().length() != 0) {
            result = "/* " + this.getComment() + "*/\n";
        }
        if (!this.getLocals().isEmpty()) {
            result = result + JavaUtil.collectionToJavaString(this.getLocals(), "\n") + "\n";
        }
        result = result + JavaUtil.collectionToJavaString(this.getStatements(), "\n");
        return result;
    }

    @Override
    public OJBlock getCopy() {
        OJBlock newBody = new OJBlock();
        ArrayList<OJStatement> stats = new ArrayList<OJStatement>(this.getStatements());
        newBody.setStatements(stats);
        return newBody;
    }

    @Override
    public OJBlock getDeepCopy() {
        OJBlock copy = new OJBlock();
        this.copyDeepInfoInto(copy);
        return copy;
    }

    public void copyDeepInfoInto(OJBlock copy) {
        for (OJStatement statement : this.getStatements()) {
            copy.addToStatements(statement.getDeepCopy());
        }
        for (OJField ojField : this.getLocals()) {
            copy.addToLocals(ojField.getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        for (OJStatement statement : this.getStatements()) {
            statement.renameAll(renamePathNames, newName);
        }
        for (OJField ojField : this.getLocals()) {
            ojField.renameAll(renamePathNames, newName);
        }
    }

    public OJStatement findStatement(String name) {
        for (OJStatement statement : this.getStatements()) {
            if (statement.getName() == null || !statement.getName().equals(name)) continue;
            return statement;
        }
        return null;
    }

    public OJStatement findStatementRecursive(String name) {
        for (OJStatement statement : this.getStatements()) {
            OJStatement s;
            OJStatement ifs;
            if (statement.getName() != null && statement.getName().equals(name)) {
                return statement;
            }
            if (statement instanceof OJIfStatement) {
                ifs = (OJIfStatement)statement;
                s = ((OJIfStatementGEN)ifs).getThenPart().findStatementRecursive(name);
                if (s == null && ((OJIfStatementGEN)ifs).getElsePart() != null) {
                    s = ((OJIfStatementGEN)ifs).getElsePart().findStatementRecursive(name);
                }
                if (s == null) continue;
                return s;
            }
            if (!(statement instanceof OJForStatement) || (s = ((OJForStatementGEN)(ifs = (OJForStatement)statement)).getBody().findStatementRecursive(name)) == null) continue;
            return s;
        }
        return null;
    }

    public OJField findLocal(String name) {
        for (OJField field : this.getLocals()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }
}

