/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.Set;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJStatement;
import org.umlg.java.metamodel.generated.OJIfStatementGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;

public class OJIfStatement
extends OJIfStatementGEN {
    public OJIfStatement() {
        this.setThenPart(new OJBlock());
    }

    public OJIfStatement(String condition, String thenPart) {
        this.setThenPart(new OJBlock());
        this.setCondition(condition);
        this.addToThenPart(thenPart);
    }

    public OJIfStatement(String condition, String thenPart, String elsePart) {
        this.setThenPart(new OJBlock());
        this.setCondition(condition);
        this.addToThenPart(thenPart);
        this.addToElsePart(elsePart);
    }

    public OJIfStatement(String condition) {
        this.setThenPart(new OJBlock());
        this.setCondition(condition);
    }

    public void addToThenPart(String string) {
        this.getThenPart().addToStatements(string);
    }

    public void addToElsePart(String string) {
        if (this.getElsePart() == null) {
            this.setElsePart(new OJBlock());
        }
        this.getElsePart().addToStatements(string);
    }

    public void addToThenPart(OJStatement stat) {
        if (stat == null) {
            return;
        }
        this.getThenPart().addToStatements(stat);
    }

    public void addToElsePart(OJStatement stat) {
        if (this.getElsePart() == null) {
            this.setElsePart(new OJBlock());
        }
        this.getElsePart().addToStatements(stat);
    }

    @Override
    public String toJavaString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getComment().equals("")) {
            this.addJavaDocComment(sb);
        }
        String result = sb.toString();
        result = result + "if ( " + this.getCondition() + " ) {\n";
        result = result + JavaStringHelpers.indent(this.getThenPart().toJavaString(), 1) + "\n}";
        int count = 0;
        for (OJBlock elseIf : this.elseIfPart) {
            result = result + " else if ( " + (String)this.elseIfCondition.get(count) + " ) {\n" + JavaStringHelpers.indent(elseIf.toJavaString(), 1) + "\n}";
            ++count;
        }
        if (this.getElsePart() != null) {
            result = result + " else {\n" + JavaStringHelpers.indent(this.getElsePart().toJavaString(), 1) + "\n}";
        }
        return result;
    }

    @Override
    public OJIfStatement getDeepCopy() {
        OJIfStatement copy = new OJIfStatement();
        this.copyDeepInfoInto(copy);
        return copy;
    }

    public void copyDeepInfoInto(OJIfStatement copy) {
        super.copyDeepInfoInto(copy);
        copy.setCondition(this.getCondition());
        if (this.getThenPart() != null) {
            copy.setThenPart(this.getThenPart().getDeepCopy());
        }
        if (this.getElsePart() != null) {
            copy.setElsePart(this.getElsePart().getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        this.setCondition(OJIfStatement.replaceAll(this.getCondition(), renamePathNames, suffix));
        if (this.getThenPart() != null) {
            this.getThenPart().renameAll(renamePathNames, suffix);
        }
        if (this.getElsePart() != null) {
            this.getElsePart().renameAll(renamePathNames, suffix);
        }
    }

    protected void addJavaDocComment(StringBuilder result) {
        String comment = this.getComment();
        comment = JavaStringHelpers.replaceAllSubstrings(comment, "\n", "\n * ");
        result.append("//");
        result.append(comment);
        result.append("\n");
    }
}

