/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Set;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJSwitchCase;
import org.umlg.java.metamodel.generated.OJSwitchStatementGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;

public class OJSwitchStatement
extends OJSwitchStatementGEN {
    @Override
    public String toJavaString() {
        OJSwitchCase c2;
        String result = "switch ( " + this.getCondition() + " ) {\n";
        for (OJSwitchCase c2 : this.getCases()) {
            result = result + JavaStringHelpers.indent(c2.toJavaString(), 1) + "\n";
        }
        c2 = this.getDefCase();
        if (c2 != null) {
            result = result + JavaStringHelpers.indent("default", 1) + c2.getLabel() + ":\n" + JavaStringHelpers.indent(c2.getBody().toJavaString(), 2) + "\n";
        }
        result = result + "}\n";
        return result;
    }

    @Override
    public OJSwitchStatement getDeepCopy() {
        OJSwitchStatement copy = new OJSwitchStatement();
        this.copyDeepInfoInto(copy);
        return copy;
    }

    public void copyDeepInfoInto(OJSwitchStatement copy) {
        super.copyDeepInfoInto(copy);
        copy.setCondition(this.getCondition());
        for (OJSwitchCase elem : new ArrayList<OJSwitchCase>(this.getCases())) {
            copy.addToCases(elem.getDeepCopy());
        }
        if (this.getDefCase() != null) {
            copy.setDefCase(this.getDefCase().getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        for (OJSwitchCase elem : new ArrayList<OJSwitchCase>(this.getCases())) {
            elem.renameAll(renamePathNames, newName);
        }
        if (this.getDefCase() != null) {
            this.getDefCase().renameAll(renamePathNames, newName);
        }
    }
}

