/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.umlg.java.metamodel.OJClass;
import org.umlg.java.metamodel.OJElement;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.utilities.InvariantError;

public class OJWorkspace
extends OJElement {
    private Set<OJPackage> f_rootPackages = new HashSet<OJPackage>();

    public void release() {
        for (OJPackage p : this.getRootPackages()) {
            p.release();
        }
    }

    public OJClass findClass(OJPathName path) {
        OJPackage pkg = this.findLocalPackage(path.getFirst());
        if (pkg == null) {
            return null;
        }
        return pkg.findClass(path.getTail());
    }

    public OJPackage findPackage(OJPathName path) {
        if (path.isSingleName()) {
            return this.findLocalPackage(path.getLast());
        }
        OJPackage lp = this.findLocalPackage(path.getFirst());
        if (lp != null) {
            return lp.findPackage(path.getTail());
        }
        return null;
    }

    protected OJPackage findLocalPackage(String name) {
        return this.any2(name);
    }

    public void setRootPackages(Set<OJPackage> elements) {
        if (this.f_rootPackages != elements) {
            this.f_rootPackages = elements;
        }
    }

    public synchronized void addToRootPackages(OJPackage element) {
        if (element == null) {
            return;
        }
        if (this.f_rootPackages.contains(element)) {
            this.f_rootPackages.remove(element);
        }
        this.f_rootPackages.add(element);
    }

    public void removeFromRootPackages(OJPackage element) {
        if (element == null) {
            return;
        }
        this.f_rootPackages.remove(element);
    }

    public Set<OJPackage> getRootPackages() {
        if (this.f_rootPackages != null) {
            return Collections.unmodifiableSet(this.f_rootPackages);
        }
        return null;
    }

    public void z_internalAddToRootPackages(OJPackage element) {
        for (OJPackage pkg : this.f_rootPackages) {
            if (!pkg.getName().equals(element.getName())) continue;
            throw new RuntimeException();
        }
        this.f_rootPackages.add(element);
    }

    public void z_internalRemoveFromRootPackages(OJPackage element) {
        this.f_rootPackages.remove(element);
    }

    public void addToRootPackages(Collection<OJPackage> newElems) {
        for (OJPackage item : newElems) {
            if (!(item instanceof OJPackage)) continue;
            this.addToRootPackages(item);
        }
    }

    public void removeFromRootPackages(Collection<OJPackage> oldElems) {
        for (OJPackage item : oldElems) {
            if (!(item instanceof OJPackage)) continue;
            this.removeFromRootPackages(item);
        }
    }

    public void removeAllFromRootPackages() {
        for (OJPackage item : new HashSet<OJPackage>(this.getRootPackages())) {
            if (!(item instanceof OJPackage)) continue;
            this.removeFromRootPackages(item);
        }
    }

    private OJPackage any2(String name) {
        OJPackage result = null;
        for (OJPackage c : this.getRootPackages()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return result;
    }

    @Override
    public List<InvariantError> checkAllInvariants() {
        ArrayList<InvariantError> result = new ArrayList<InvariantError>();
        return result;
    }

    @Override
    public String toString() {
        String result = "";
        result = super.toString();
        return result;
    }

    @Override
    public String getIdString() {
        String result = "";
        result = super.getIdString();
        return result;
    }

    public OJElement getCopy() {
        OJWorkspace result = new OJWorkspace();
        this.copyInfoInto(result);
        return result;
    }

    public void copyInfoInto(OJWorkspace copy) {
        super.copyInfoInto(copy);
        for (OJPackage elem : new ArrayList<OJPackage>(this.getRootPackages())) {
            copy.addToRootPackages(elem);
        }
    }

    @Override
    public void renameAll(Set<OJPathName> match, String suffix) {
        Set<OJPackage> rootpackages = this.getRootPackages();
        for (OJPackage p : rootpackages) {
            p.renameAll(match, suffix);
        }
    }

    public OJPackage findOrCreatePackage(OJPathName packageName) {
        OJPackage parent = this.findLocalPackage(packageName.getFirst());
        if (parent == null) {
            parent = new OJPackage(packageName.getFirst());
            this.addToRootPackages(parent);
        }
        OJPackage child = parent;
        for (String name : packageName.getNames().subList(1, packageName.getNames().size())) {
            child = parent.findPackage(new OJPathName(name));
            if (child == null) {
                child = new OJPackage(name);
                parent.addToSubpackages(child);
            }
            parent = child;
        }
        return child;
    }
}

