/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.umlg.java.metamodel.OJElement;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;

public class AnnotationHelper {
    public static Set<OJPathName> getImportsFrom(Collection<? extends OJElement> sources) {
        HashSet<OJPathName> result = new HashSet<OJPathName>();
        for (OJElement oJElement : sources) {
            if (!(oJElement instanceof OJAnnotatedElement)) continue;
            AnnotationHelper.addTypesUsed((OJAnnotatedElement)((Object)oJElement), result);
        }
        return result;
    }

    public static Set<OJPathName> getImportsFrom(OJAnnotatedElement element) {
        HashSet<OJPathName> result = new HashSet<OJPathName>();
        AnnotationHelper.addTypesUsed(element, result);
        return result;
    }

    private static void addTypesUsed(OJAnnotatedElement element, Set<OJPathName> result) {
        for (OJAnnotationValue v : element.getAnnotations()) {
            result.addAll(v.getAllTypesUsed());
        }
    }

    public static boolean maybeAddAnnotation(OJAnnotationValue value, OJAnnotatedElement target) {
        Collection<OJAnnotationValue> sourceSet = target.getAnnotations();
        Iterator<OJAnnotationValue> iter = sourceSet.iterator();
        while (iter.hasNext()) {
            if (!value.getType().equals(iter.next().getType())) continue;
            return false;
        }
        sourceSet.add(value);
        return true;
    }

    public static OJAnnotationValue getAnnotation(OJAnnotatedElement target, OJPathName path) {
        for (OJAnnotationValue v : target.getAnnotations()) {
            if (!v.getType().equals(path)) continue;
            return v;
        }
        return null;
    }
}

