/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotationAttributeValue;
import org.umlg.java.metamodel.annotation.OJEnumValue;
import org.umlg.java.metamodel.annotation.OJMetaValue;

public class OJAnnotationValue
extends OJMetaValue {
    private OJPathName type;
    private SortedMap<String, OJAnnotationAttributeValue> attributes = new TreeMap<String, OJAnnotationAttributeValue>();

    public OJAnnotationValue() {
    }

    public OJAnnotationValue(OJPathName type) {
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, Boolean value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, Number value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, OJAnnotationValue value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, OJPathName value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, String value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationValue(OJPathName type, OJEnumValue value) {
        super(value);
        super.setName(type.getLast());
        this.type = type;
    }

    public OJAnnotationAttributeValue putAttribute(String name, Boolean booleanValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, booleanValue));
    }

    public OJAnnotationAttributeValue putAttribute(String name, Number numberValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, numberValue));
    }

    public OJAnnotationAttributeValue putAttribute(String name, OJAnnotationValue annotationValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, annotationValue));
    }

    public OJAnnotationAttributeValue putAttribute(String name, OJPathName classValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, classValue));
    }

    public OJAnnotationAttributeValue putAttribute(String name, OJEnumValue ojEnumValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, ojEnumValue));
    }

    public OJAnnotationAttributeValue putAttribute(String name, String stringValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, stringValue));
    }

    public OJAnnotationAttributeValue putEnumAttribute(String name, OJEnumValue enumValue) {
        return this.putAttribute(new OJAnnotationAttributeValue(name, enumValue));
    }

    public Set<OJPathName> getAllTypesUsed() {
        HashSet<OJPathName> set = new HashSet<OJPathName>();
        this.addTypesUsed(set);
        return set;
    }

    @Override
    public void addTypesUsed(Set<OJPathName> s) {
        if (this.isImportType()) {
            s.add(this.type);
        }
        super.addTypesUsed(s);
        for (OJAnnotationAttributeValue o : this.attributes.values()) {
            o.addTypesUsed(s);
        }
    }

    @Override
    public String toJavaString() {
        String referencedName;
        String string = referencedName = this.isImportType() ? this.type.getLast() : this.type.toJavaString();
        if (this.attributes.isEmpty() && this.values.size() > 0) {
            return "@" + referencedName + "(" + super.toJavaValueExpression() + ")";
        }
        if (this.attributes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("@");
            sb.append(referencedName);
            sb.append("(");
            Iterator<OJAnnotationAttributeValue> a = this.attributes.values().iterator();
            while (a.hasNext()) {
                OJMetaValue attr = a.next();
                sb.append(attr.toJavaString());
                if (!a.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        return "@" + referencedName;
    }

    public OJAnnotationAttributeValue putAttribute(OJAnnotationAttributeValue annotationAttribute) {
        return this.attributes.put(annotationAttribute.getName(), annotationAttribute);
    }

    public OJAnnotationAttributeValue removeAttribute(OJAnnotationAttributeValue annotationAttribute) {
        return (OJAnnotationAttributeValue)this.attributes.remove(annotationAttribute);
    }

    public OJPathName getType() {
        return this.type;
    }

    public boolean hasAttribute(String string) {
        OJAnnotationAttributeValue result = this.findAttribute(string);
        return result != null;
    }

    public OJAnnotationAttributeValue findAttribute(String string) {
        return (OJAnnotationAttributeValue)this.attributes.get(string);
    }

    public void setType(OJPathName pathName) {
        this.type = pathName;
    }

    public OJAnnotationValue getCopy() {
        OJAnnotationValue result = new OJAnnotationValue();
        this.copyInfoInto(result);
        return result;
    }

    protected void copyInfoInto(OJAnnotationValue result) {
        super.copyInfoInto(result);
        result.type = this.type.getCopy();
        result.attributes = new TreeMap<String, OJAnnotationAttributeValue>();
        for (OJAnnotationAttributeValue v : this.attributes.values()) {
            result.attributes.put(v.getName(), v.getCopy());
        }
    }

    public OJAnnotationValue getDeepCopy() {
        OJAnnotationValue result = new OJAnnotationValue();
        this.copyDeepInfoInto(result);
        return result;
    }

    protected void copyDeepInfoInto(OJAnnotationValue result) {
        super.copyDeepInfoInto(result);
        result.type = this.type.getDeepCopy();
        result.attributes = new TreeMap<String, OJAnnotationAttributeValue>();
        for (OJAnnotationAttributeValue v : this.attributes.values()) {
            result.attributes.put(v.getName(), v.getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        super.renameAll(renamePathNames, newName);
        for (OJAnnotationAttributeValue attr : this.attributes.values()) {
            attr.renameAll(renamePathNames, newName);
        }
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }
}

